/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.agent.plugins;

import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import net.roboconf.agent.AgentMessagingInterface;
import net.roboconf.core.utils.ProcessStore;
import net.roboconf.core.utils.Utils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="roboconf", name="cancel-recipe", description="Cancel a running recipe.")
@Service
public class CancelRecipeCommand
implements Action {
    @Argument(index=0, name="applicationName", description="The application name.", required=false, multiValued=false)
    String applicationName = null;
    @Argument(index=1, name="scopedInstancePath", description="The root instance path.", required=false, multiValued=false)
    String scopedInstancePath = null;
    @Reference
    List<AgentMessagingInterface> agents;
    PrintStream out = System.out;

    public Object execute() throws Exception {
        if (this.agents != null) {
            boolean single = this.agents.size() == 1;
            for (AgentMessagingInterface agent : this.agents) {
                this.out.println("Found agent with appname=" + agent.getApplicationName());
                if (single) {
                    if (this.scopedInstancePath != null && !this.scopedInstancePath.equals(agent.getScopedInstancePath())) continue;
                    this.out.println("Single agent eligible to cancel recipe");
                    this.cancelRecipe(agent.getApplicationName(), agent.getScopedInstancePath());
                    continue;
                }
                if (!Objects.equals(agent.getApplicationName(), this.applicationName) || this.scopedInstancePath != null && !this.scopedInstancePath.equals(agent.getScopedInstancePath())) continue;
                this.out.println("Agent is eligible to cancel recipe");
                this.cancelRecipe(this.applicationName, this.scopedInstancePath);
            }
        } else {
            this.out.println("No agent found, command not applicable");
        }
        return null;
    }

    private void cancelRecipe(String applicationName, String scopedInstancePath) {
        if (Utils.isEmptyOrWhitespaces((String)applicationName)) {
            applicationName = "";
        }
        if (Utils.isEmptyOrWhitespaces((String)scopedInstancePath)) {
            scopedInstancePath = "";
        }
        this.out.println("looking up [" + applicationName + "] [" + scopedInstancePath + "]");
        Process p = ProcessStore.getProcess((String)applicationName, (String)scopedInstancePath);
        if (p != null) {
            p.destroy();
            ProcessStore.clearProcess((String)applicationName, (String)scopedInstancePath);
            this.out.println("Recipe cancelled !");
        } else {
            this.out.println("No running recipe to cancel.");
        }
    }
}

