/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.agent.status;

import java.util.List;
import java.util.logging.Logger;
import net.roboconf.agent.AgentMessagingInterface;
import net.roboconf.core.utils.Utils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="roboconf", name="agent-status", description="Gives an agent status")
@Service
public class AgentStatusCommand
implements Action {
    final Logger logger = Logger.getLogger(this.getClass().getName());
    @Reference
    List<AgentMessagingInterface> agents;

    public Object execute() throws Exception {
        if (this.agents != null) {
            for (AgentMessagingInterface agent : this.agents) {
                try {
                    System.out.println(agent.agentStatus());
                    System.out.println("");
                }
                catch (Exception e) {
                    this.logger.warning("An error occurred while giving agent status. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
        return null;
    }
}

