/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.agents;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;

public final class DataHelpers {
    public static final String SCOPED_INSTANCE_PATH = "scoped.instance.path";
    public static final String APPLICATION_NAME = "application.name";
    public static final String DOMAIN = "domain";

    private DataHelpers() {
    }

    public static String writeUserDataAsString(Map<String, String> messagingConfiguration, String domain, String applicationName, String scopedInstancePath) throws IOException {
        Properties props = DataHelpers.writeUserDataAsProperties(messagingConfiguration, domain, applicationName, scopedInstancePath);
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        return writer.toString();
    }

    public static Properties writeUserDataAsProperties(Map<String, String> messagingConfiguration, String domain, String applicationName, String scopedInstancePath) {
        Properties result = new Properties();
        if (applicationName != null) {
            result.setProperty(APPLICATION_NAME, applicationName);
        }
        if (scopedInstancePath != null) {
            result.setProperty(SCOPED_INSTANCE_PATH, scopedInstancePath);
        }
        if (domain != null) {
            result.setProperty(DOMAIN, domain);
        }
        if (messagingConfiguration != null) {
            for (Map.Entry<String, String> e : messagingConfiguration.entrySet()) {
                if (e.getValue() == null) continue;
                result.setProperty(e.getKey(), e.getValue());
            }
        }
        return result;
    }

    public static Properties readUserData(String rawProperties) throws IOException {
        Properties result = new Properties();
        StringReader reader = new StringReader(rawProperties);
        result.load(reader);
        return result;
    }
}

