/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.autonomic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.autonomic.Rule;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class RuleParser {
    private static final Pattern RULE_PATTERN = Pattern.compile("(?is)^\\s*rule\\s+\"([^\"]*)\"\\s+(.*)when\\s+(.+)\\s+then\\s+(.+)\\s+end\\s*$");
    private static final Pattern SLEEP_PERIOD_PATTERN = Pattern.compile("(?i)\\bsleep period is\\s+(\\d+)s?");
    private static final Pattern TIME_WINDOW_PATTERN = Pattern.compile("(?i)\\btime window is\\s+(\\d+)s?");
    private static final String SINGLE_COMMENT_PATTERN = "//.*\r?\n";
    private static final String SINGLE_SHARP_COMMENT_PATTERN = "#.*\r?\n";
    private static final String MULTILINE_COMMENT_PATTERN = "(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)";
    private final List<ParsingError> parsingErrors = new ArrayList<ParsingError>();
    private final Rule rule = new Rule();

    public RuleParser(File ruleFile) {
        String details = "File name: " + ruleFile.getName();
        try {
            String s = Utils.readFileContent(ruleFile);
            s = s.replaceAll(MULTILINE_COMMENT_PATTERN, "");
            s = s.replaceAll(SINGLE_COMMENT_PATTERN, "");
            s = s.replaceAll(SINGLE_SHARP_COMMENT_PATTERN, "");
            s = s.trim();
            Matcher m = RULE_PATTERN.matcher(s);
            if (!m.matches()) {
                this.parsingErrors.add(new ParsingError(ErrorCode.RULE_INVALID_SYNTAX, ruleFile, -1));
            } else {
                String ruleName = m.group(1).trim();
                this.rule.setRuleName(ruleName);
                String eventName = m.group(3).trim();
                this.rule.setEventName(eventName);
                String commandNames = m.group(4);
                for (String commandName : Utils.splitNicelyWithPattern(commandNames, ";|\r?\n")) {
                    if (Utils.isEmptyOrWhitespaces(commandName)) continue;
                    this.rule.getCommandsToInvoke().add(commandName);
                }
                String properties = m.group(2);
                if ((m = TIME_WINDOW_PATTERN.matcher(properties)).find()) {
                    this.rule.setTimingWindow(Integer.parseInt(m.group(1)));
                }
                if ((m = SLEEP_PERIOD_PATTERN.matcher(properties)).find()) {
                    this.rule.setDelayBetweenSucceedingInvocations(Integer.parseInt(m.group(1)));
                }
                if (Utils.isEmptyOrWhitespaces(ruleName)) {
                    this.parsingErrors.add(new ParsingError(ErrorCode.RULE_EMPTY_NAME, ruleFile, -1, details));
                }
                if (Utils.isEmptyOrWhitespaces(eventName)) {
                    this.parsingErrors.add(new ParsingError(ErrorCode.RULE_EMPTY_WHEN, ruleFile, -1, details));
                }
                if (this.rule.getCommandsToInvoke().isEmpty()) {
                    this.parsingErrors.add(new ParsingError(ErrorCode.RULE_EMPTY_THEN, ruleFile, -1, details));
                }
            }
        }
        catch (IOException e) {
            this.parsingErrors.add(new ParsingError(ErrorCode.RULE_IO_ERROR, ruleFile, -1, details));
        }
    }

    public List<ParsingError> getParsingErrors() {
        return this.parsingErrors;
    }

    public Rule getRule() {
        return this.rule;
    }
}

