/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;

public class AssociateTargetCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "associate";
    private String targetId;
    private String scopedInstancePath;

    AssociateTargetCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("associate\\s+(/.*)\\s+with\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.targetId = m.group(2).trim();
            this.scopedInstancePath = m.group(1).trim();
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        Instance resolvedInstance;
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.targetId)) {
            result.add(this.error(ErrorCode.CMD_INVALID_TARGET_ID, "Target ID: " + this.targetId));
        }
        if ((resolvedInstance = this.context.resolveInstance(this.scopedInstancePath)) == null) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE, "Instance path: " + this.scopedInstancePath));
        } else if (!InstanceHelpers.isTarget(resolvedInstance)) {
            result.add(this.error(ErrorCode.CMD_NOT_A_SCOPED_INSTANCE));
        }
        return result;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getScopedInstancePath() {
        return this.scopedInstancePath;
    }
}

