/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.utils.Utils;

public class CreateInstanceCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "create";
    private String instanceName;
    private String componentName;
    private String parentInstancePath;
    private Component component;

    CreateInstanceCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("create\\s+(.*)\\s*as\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.componentName = m.group(1).trim();
            this.component = ComponentHelpers.findComponent(context.getApp(), this.componentName);
            this.instanceName = m.group(2).trim();
            Pattern subP = Pattern.compile("(.*)\\s+under\\s+(.*)", 2);
            m = subP.matcher(this.instanceName);
            if (m.matches()) {
                this.instanceName = m.group(1).trim();
                this.parentInstancePath = m.group(2).trim();
            }
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.componentName)) {
            result.add(this.error(ErrorCode.CMD_MISSING_COMPONENT_NAME));
        } else if (this.component == null) {
            result.add(this.error(ErrorCode.CMD_INEXISTING_COMPONENT, "Component name: " + this.componentName));
        } else if (!this.component.getAncestors().isEmpty()) {
            if (this.parentInstancePath == null) {
                result.add(this.error(ErrorCode.CMD_MISSING_PARENT_INSTANCE));
            } else {
                Instance resolvedParentInstance = this.context.resolveInstance(this.parentInstancePath);
                if (resolvedParentInstance == null) {
                    result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE, "Instance path: " + this.parentInstancePath));
                } else if (!this.component.getAncestors().contains(resolvedParentInstance.getComponent())) {
                    result.add(this.error(ErrorCode.CMD_NOT_AN_ACCEPTABLE_PARENT, "Component name: " + this.componentName));
                }
            }
        } else if (this.parentInstancePath != null) {
            result.add(this.error(ErrorCode.CMD_CANNOT_HAVE_ANY_PARENT, "Component name: " + this.componentName));
        }
        if (Utils.isEmptyOrWhitespaces(this.instanceName)) {
            result.add(this.error(ErrorCode.CMD_MISSING_INSTANCE_NAME));
        } else if (!this.instanceName.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(this.error(ErrorCode.CMD_INVALID_INSTANCE_NAME, "Invalid name: " + this.instanceName));
        }
        String newInstancePath = (this.parentInstancePath == null ? "" : this.parentInstancePath) + "/" + this.instanceName;
        if (this.context.instancePathToComponentName.containsKey(newInstancePath)) {
            result.add(this.error(ErrorCode.CMD_CONFLICTING_INSTANCE_NAME));
        }
        return result;
    }

    @Override
    public void updateContext() {
        String newInstancePath = (this.parentInstancePath == null ? "" : this.parentInstancePath) + "/" + this.instanceName;
        this.context.instancePathToComponentName.put(newInstancePath, this.componentName);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getParentInstancePath() {
        return this.parentInstancePath;
    }

    public Component getComponent() {
        return this.component;
    }
}

