/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.CommandsParser;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class DefineVariableCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "define";
    public static final String MILLI_TIME = "$(MILLI_TIME)";
    public static final String NANO_TIME = "$(NANO_TIME)";
    public static final String FORMATTED_TIME_PREFIX = "$(FORMATTED_TIME ";
    public static final String RANDOM_UUID = "$(UUID)";
    public static final String SMART_INDEX = "$(SMART_INDEX)";
    private String key;
    private String value;
    private String instancePath;

    DefineVariableCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("define\\s+([^=]*)\\s*=\\s*(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.key = m.group(1).trim();
            this.value = m.group(2).trim();
            Pattern subP = Pattern.compile("(.*)\\s+under\\s+(.*)", 2);
            m = subP.matcher(this.value);
            if (m.matches()) {
                this.value = m.group(1).trim();
                this.instancePath = m.group(2).trim();
            }
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.key)) {
            result.add(this.error(ErrorCode.CMD_EMPTY_VARIABLE_NAME));
        } else if (this.value.startsWith(FORMATTED_TIME_PREFIX) && this.value.endsWith(")")) {
            String datePattern = DefineVariableCommandInstruction.extractDatePattern(this.value);
            if (datePattern.contains("$(")) {
                result.add(this.error(ErrorCode.CMD_NO_MIX_FOR_PATTERNS, "Variable: " + this.key));
            } else {
                try {
                    new SimpleDateFormat(datePattern);
                }
                catch (Exception e) {
                    result.add(this.error(ErrorCode.CMD_INVALID_DATE_PATTERN, "Pattern: " + datePattern));
                }
            }
        } else if (this.value.contains(FORMATTED_TIME_PREFIX)) {
            result.add(this.error(ErrorCode.CMD_NO_MIX_FOR_PATTERNS, "Variable: " + this.value));
        }
        if (result.isEmpty() && this.instancePath != null && !this.context.instanceExists(this.instancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE));
        }
        return result;
    }

    @Override
    public void updateContext() {
        String newValue = DefineVariableCommandInstruction.replaceVariables(this.value, this.context, this.instancePath);
        this.context.variables.put(this.key, newValue);
    }

    @Override
    protected List<String> getVariablesToIgnore() {
        ArrayList<String> variablesToIgnore = new ArrayList<String>();
        variablesToIgnore.add("^" + Pattern.quote(MILLI_TIME) + "$");
        variablesToIgnore.add("^" + Pattern.quote(NANO_TIME) + "$");
        variablesToIgnore.add("^" + Pattern.quote(SMART_INDEX) + "$");
        variablesToIgnore.add("^" + Pattern.quote(RANDOM_UUID) + "$");
        for (String var : this.context.variables.keySet()) {
            variablesToIgnore.add("^\\$\\(" + Pattern.quote(var) + "\\)$");
        }
        variablesToIgnore.add("^" + Pattern.quote(FORMATTED_TIME_PREFIX) + ".*\\)$");
        return variablesToIgnore;
    }

    static String extractDatePattern(String group) {
        return group.substring(FORMATTED_TIME_PREFIX.length(), group.length() - 2).trim();
    }

    static String replaceVariables(String name, Context context, String parentInstancePath) {
        long nanoTime = System.nanoTime();
        long milliTime = TimeUnit.MILLISECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
        name = name.replace(NANO_TIME, String.valueOf(nanoTime));
        name = name.replace(MILLI_TIME, String.valueOf(milliTime));
        if ((name = name.replace(RANDOM_UUID, UUID.randomUUID().toString())).startsWith(FORMATTED_TIME_PREFIX) && name.endsWith(")")) {
            String datePattern = DefineVariableCommandInstruction.extractDatePattern(name);
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            name = sdf.format(new Date(milliTime));
        }
        int smartCpt = 0;
        if (name.contains(SMART_INDEX)) {
            int cpt = 1;
            while (smartCpt == 0) {
                String testName = name.replace(SMART_INDEX, String.valueOf(cpt));
                String testPath = "/" + testName;
                if (parentInstancePath != null) {
                    testPath = parentInstancePath + testPath;
                }
                if (!context.instanceExists(testPath)) {
                    smartCpt = cpt;
                }
                ++cpt;
            }
        }
        name = name.replace(SMART_INDEX, String.valueOf(smartCpt));
        name = CommandsParser.injectContextVariables(name, context.variables);
        return name;
    }
}

