/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class ExecuteCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "execute";
    private String commandName;

    ExecuteCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("execute\\s+(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.commandName = m.group(1).trim();
            if (this.commandName.endsWith(".commands")) {
                this.commandName = this.commandName.substring(0, this.commandName.lastIndexOf(46));
            }
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        String fileName = this.commandName + ".commands";
        File commandsDirectory = new File(this.context.getApp().getDirectory(), "commands");
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.commandName)) {
            result.add(this.error(ErrorCode.CMD_MISSING_COMMAND_NAME));
        } else if (this.context.getCommandFile() != null && fileName.equals(this.context.getCommandFile().getName())) {
            result.add(this.error(ErrorCode.CMD_LOOPING_COMMAND, "Command name: " + this.commandName));
        } else {
            File commandFileToExecute = new File(commandsDirectory, fileName);
            if (!commandFileToExecute.exists()) {
                result.add(this.error(ErrorCode.CMD_INEXISTING_COMMAND, "Command name: " + this.commandName));
            } else {
                try {
                    String content = Utils.readFileContent(commandFileToExecute);
                    Pattern p = Pattern.compile("execute\\s+" + Pattern.quote(this.commandName), 2);
                    if (p.matcher(content).find()) {
                        result.add(this.error(ErrorCode.CMD_NASTY_LOOPING_COMMAND, "Command name: " + this.commandName));
                    }
                }
                catch (IOException e) {
                    Utils.logException(Logger.getLogger(this.getClass().getName()), e);
                }
            }
        }
        return result;
    }

    public String getCommandName() {
        return this.commandName;
    }
}

