/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class RenameCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "rename";
    private String newInstanceName;
    private String instancePath;

    RenameCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("rename\\s+(/.*)\\s*as\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.instancePath = m.group(1).trim();
            this.newInstanceName = m.group(2).trim();
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.newInstanceName)) {
            result.add(this.error(ErrorCode.CMD_MISSING_INSTANCE_NAME));
        } else if (!this.newInstanceName.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(this.error(ErrorCode.CMD_INVALID_INSTANCE_NAME, "Invalid name: " + this.newInstanceName));
        }
        if (!this.context.instanceExists(this.instancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE, "Instance path: " + this.instancePath));
        } else {
            String parentInstancePath = this.instancePath.replaceFirst("/[^/]+$", "");
            String siblingPath = parentInstancePath + "/" + this.newInstanceName;
            if (this.context.instanceExists(siblingPath)) {
                result.add(this.error(ErrorCode.CMD_CONFLICTING_INSTANCE_NAME, "Conflicting instance: " + siblingPath));
            }
        }
        return result;
    }

    @Override
    public void updateContext() {
        String newInstancePath = "/" + this.instancePath.replaceFirst("/[^/]+$", this.newInstanceName);
        HashMap<String, String> copy = new HashMap<String, String>(this.context.instancePathToComponentName);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((String)entry.getKey()).startsWith(this.instancePath + "/") && !((String)entry.getKey()).equals(this.instancePath)) continue;
            String updatedPath = ((String)entry.getKey()).replace(this.instancePath, newInstancePath);
            this.context.instancePathToComponentName.remove(entry.getKey());
            this.context.instancePathToComponentName.put(updatedPath, (String)entry.getValue());
        }
    }

    public String getNewInstanceName() {
        return this.newInstanceName;
    }

    public String getInstancePath() {
        return this.instancePath;
    }
}

