/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;

public class ReplicateCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "replicate";
    private String newInstanceName;
    private String replicatedInstancePath;

    ReplicateCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("replicate\\s+(/.*)\\s*as\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.newInstanceName = m.group(2).trim();
            this.replicatedInstancePath = m.group(1).trim();
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.newInstanceName)) {
            result.add(this.error(ErrorCode.CMD_MISSING_INSTANCE_NAME));
        } else if (!this.newInstanceName.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(this.error(ErrorCode.CMD_INVALID_INSTANCE_NAME));
        }
        if (!this.context.instanceExists(this.replicatedInstancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE, "Instance path: " + this.replicatedInstancePath));
        } else if (InstanceHelpers.countInstances(this.replicatedInstancePath) > 1) {
            result.add(this.error(ErrorCode.CMD_NOT_A_ROOT_INSTANCE, "Only root instances can be replicated."));
        }
        return result;
    }

    @Override
    public void updateContext() {
        String copyInstancePath = "/" + this.replicatedInstancePath.replaceFirst("/[^/]+$", this.newInstanceName);
        HashMap<String, String> pathToAdd = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.context.instancePathToComponentName.entrySet()) {
            if (!entry.getKey().startsWith(this.replicatedInstancePath + "/") && !entry.getKey().equals(this.replicatedInstancePath)) continue;
            String updatedPath = entry.getKey().replace(this.replicatedInstancePath, copyInstancePath);
            pathToAdd.put(updatedPath, entry.getValue());
        }
        this.context.instancePathToComponentName.putAll(pathToAdd);
    }

    public String getNewInstanceName() {
        return this.newInstanceName;
    }

    public String getReplicatedInstancePath() {
        return this.replicatedInstancePath;
    }
}

