/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class WriteCommandInstruction
extends AbstractCommandInstruction {
    static final String TMP = "%TMP%";
    static final String WRITE_PREFIX = "write";
    private String content;
    private String filePath;

    WriteCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile(this.getPrefix() + "\\s+(.*)\\s*into\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.content = m.group(1).trim();
            this.filePath = m.group(2).trim().replaceAll(TMP, WriteCommandInstruction.findTemporaryDir());
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.filePath)) {
            result.add(new ParsingError(ErrorCode.CMD_MISSING_TARGET_FILE, this.context.getCommandFile(), this.line));
        }
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public String getFilePath() {
        return this.filePath;
    }

    protected String getPrefix() {
        return WRITE_PREFIX;
    }

    static String findTemporaryDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        tmpDir = tmpDir.replaceAll("/$", "");
        return tmpDir;
    }
}

