/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionParser;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.RoboconfErrorHelpers;
import net.roboconf.core.utils.ModelUtils;

public class FromInstanceDefinition {
    private static final String INST_COUNT = "count";
    private final File rootDirectory;
    private Graphs graphs;
    private final Collection<ParsingError> errors = new ArrayList<ParsingError>();
    private final Map<Object, SourceReference> objectToSource = new HashMap<Object, SourceReference>();
    private Map<BlockInstanceOf, Instance> allBlocksToInstances;
    private Set<File> importsToProcess;
    private Set<File> processedImports;

    public FromInstanceDefinition(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public Collection<ParsingError> getErrors() {
        return this.errors;
    }

    public Set<File> getProcessedImports() {
        return this.processedImports;
    }

    public Map<Object, SourceReference> getObjectToSource() {
        return this.objectToSource;
    }

    public Collection<Instance> buildInstances(Graphs graphs, File file) {
        this.allBlocksToInstances = new LinkedHashMap<BlockInstanceOf, Instance>();
        this.graphs = graphs;
        this.importsToProcess = new HashSet<File>();
        this.processedImports = new HashSet<File>();
        this.errors.clear();
        this.importsToProcess.add(file);
        while (!this.importsToProcess.isEmpty()) {
            File importedFile = this.importsToProcess.iterator().next();
            this.importsToProcess.remove(importedFile);
            this.processedImports.add(importedFile);
            if (!importedFile.exists()) {
                ParsingError error = new ParsingError(ErrorCode.CO_UNREACHABLE_FILE, file, 0);
                error.setDetails("Import location: " + importedFile);
                this.errors.add(error);
                continue;
            }
            FileDefinition currentDefinition = new FileDefinitionParser(importedFile, true).read();
            ArrayList<ParsingError> arrayList = new ArrayList<ParsingError>();
            arrayList.addAll(currentDefinition.getParsingErrors());
            for (AbstractBlock block : currentDefinition.getBlocks()) {
                arrayList.addAll(ParsingModelValidator.validate(block));
            }
            if (currentDefinition.getFileType() != 2 && currentDefinition.getFileType() != 3 && currentDefinition.getFileType() != 4) {
                ParsingError error = new ParsingError(ErrorCode.CO_NOT_INSTANCES, file, 0);
                error.setDetails("Imported file  " + importedFile + " is of type " + FileDefinition.fileTypeAsString(currentDefinition.getFileType()) + ".");
                arrayList.add(error);
            }
            this.errors.addAll(arrayList);
            if (RoboconfErrorHelpers.containsCriticalErrors(arrayList)) continue;
            this.processInstructions(currentDefinition);
        }
        if (this.errors.isEmpty()) {
            this.checkUnicity();
        }
        HashSet<Instance> rootInstances = new HashSet<Instance>();
        for (Instance instance : this.allBlocksToInstances.values()) {
            if (instance.getParent() != null) continue;
            rootInstances.add(instance);
        }
        if (this.errors.isEmpty()) {
            ArrayList<Instance> newRootInstances = new ArrayList<Instance>();
            for (Instance rootInstance : rootInstances) {
                newRootInstances.addAll(this.replicateInstancesFrom(rootInstance));
            }
            ArrayList arrayList = new ArrayList(newRootInstances);
            arrayList.retainAll(rootInstances);
            for (Instance instance : arrayList) {
                ParsingError error = new ParsingError(ErrorCode.CO_CONFLICTING_INFERRED_INSTANCE, file, 1);
                error.setDetails("Instance path: " + InstanceHelpers.computeInstancePath(instance));
                this.errors.add(error);
            }
            rootInstances.addAll(newRootInstances);
        }
        if (this.errors.isEmpty()) {
            this.backupSourceInformation();
        }
        return rootInstances;
    }

    private void processInstructions(FileDefinition definition) {
        for (AbstractBlock block : definition.getBlocks()) {
            switch (block.getInstructionType()) {
                case 6: {
                    this.processInstance((BlockInstanceOf)block);
                    break;
                }
                case 1: {
                    this.processImport((BlockImport)block);
                    break;
                }
            }
        }
    }

    private void processImport(BlockImport block) {
        String uri = block.getUri().trim();
        File newDefFile = new File(this.rootDirectory, uri);
        if (!this.processedImports.contains(newDefFile)) {
            this.importsToProcess.add(newDefFile);
        }
    }

    private void processInstance(BlockInstanceOf block) {
        LinkedHashMap<BlockInstanceOf, Instance> blockToInstance = new LinkedHashMap<BlockInstanceOf, Instance>();
        blockToInstance.put(block, new Instance());
        this.allBlocksToInstances.putAll(blockToInstance);
        HashMap instanceToChildrenInstances = new HashMap();
        while (!blockToInstance.isEmpty()) {
            Map.Entry entry = blockToInstance.entrySet().iterator().next();
            blockToInstance.remove(entry.getKey());
            BlockInstanceOf currentBlock = (BlockInstanceOf)entry.getKey();
            String countAsString = ModelUtils.getPropertyValue(currentBlock, INST_COUNT);
            Instance instance = (Instance)entry.getValue();
            instance.setName(ModelUtils.getPropertyValue(currentBlock, "name"));
            instance.channels.addAll(ModelUtils.getPropertyValues(currentBlock, "channels"));
            instance.setComponent(ComponentHelpers.findComponent(this.graphs, currentBlock.getName()));
            if (instance.getComponent() == null) {
                ParsingError error = new ParsingError(ErrorCode.CO_INEXISTING_COMPONENT, block.getDeclaringFile().getEditedFile(), currentBlock.getLine());
                error.setDetails("Component name: " + currentBlock.getName());
                this.errors.add(error);
                continue;
            }
            String state = ModelUtils.getPropertyValue(currentBlock, "instance-state");
            if (state != null) {
                instance.setStatus(Instance.InstanceStatus.whichStatus(state));
            }
            for (Map.Entry<String, String> dataEntry : ModelUtils.getData(currentBlock).entrySet()) {
                instance.data.put(dataEntry.getKey(), dataEntry.getValue());
            }
            instance.data.put(INST_COUNT, countAsString);
            for (AbstractBlock innerBlock : currentBlock.getInnerBlocks()) {
                if (innerBlock.getInstructionType() == 0) {
                    String pName = ((BlockProperty)innerBlock).getName();
                    if ("name".equals(pName) || "channels".equals(pName) || "instance-data".equals(pName) || "instance-state".equals(pName) || INST_COUNT.equals(pName)) continue;
                    String pValue = ((BlockProperty)innerBlock).getValue();
                    if (pName.toLowerCase().startsWith("data.")) {
                        instance.data.put(pName.substring(5), pValue);
                        continue;
                    }
                    if (pValue.matches("\\s*\".*\"\\s*")) {
                        instance.overriddenExports.put(pName, pValue.trim().substring(1, pValue.trim().length() - 1));
                        continue;
                    }
                    instance.overriddenExports.put(pName, pValue);
                    continue;
                }
                if (innerBlock.getInstructionType() != 6) continue;
                ArrayList<Instance> childrenInstances = (ArrayList<Instance>)instanceToChildrenInstances.get(instance);
                if (childrenInstances == null) {
                    childrenInstances = new ArrayList<Instance>();
                }
                Instance newInstance = new Instance();
                childrenInstances.add(newInstance);
                instanceToChildrenInstances.put(instance, childrenInstances);
                blockToInstance.put((BlockInstanceOf)innerBlock, newInstance);
                this.allBlocksToInstances.put((BlockInstanceOf)innerBlock, newInstance);
            }
        }
        for (Map.Entry entry : instanceToChildrenInstances.entrySet()) {
            for (Instance childInstance : (List)entry.getValue()) {
                InstanceHelpers.insertChild((Instance)entry.getKey(), childInstance);
            }
        }
    }

    private Collection<Instance> replicateInstancesFrom(Instance rootInstance) {
        ArrayList<Instance> newRootInstances = new ArrayList<Instance>();
        List<Instance> orderedInstances = InstanceHelpers.buildHierarchicalList(rootInstance);
        Collections.reverse(orderedInstances);
        for (Instance instance : orderedInstances) {
            String countAsString = instance.data.remove(INST_COUNT);
            Integer count = 1;
            try {
                count = Integer.parseInt(countAsString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (count <= 1) continue;
            String format = "%0" + String.valueOf(count).length() + "d";
            for (int i = 2; i <= count; ++i) {
                Instance copy = InstanceHelpers.replicateInstance(instance);
                copy.name(copy.getName() + String.format(format, i));
                if (instance.getParent() != null) {
                    InstanceHelpers.insertChild(instance.getParent(), copy);
                    continue;
                }
                newRootInstances.add(copy);
            }
            instance.name(instance.getName() + String.format(format, 1));
        }
        return newRootInstances;
    }

    private void checkUnicity() {
        HashMap<String, ArrayList<BlockInstanceOf>> instancePathToBlocks = new HashMap<String, ArrayList<BlockInstanceOf>>();
        for (Map.Entry<BlockInstanceOf, Instance> entry : this.allBlocksToInstances.entrySet()) {
            String instancePath = InstanceHelpers.computeInstancePath(entry.getValue());
            ArrayList<BlockInstanceOf> blocks = (ArrayList<BlockInstanceOf>)instancePathToBlocks.get(instancePath);
            if (blocks == null) {
                blocks = new ArrayList<BlockInstanceOf>();
            }
            blocks.add(entry.getKey());
            instancePathToBlocks.put(instancePath, blocks);
        }
        for (Map.Entry<BlockInstanceOf, Instance> entry : instancePathToBlocks.entrySet()) {
            if (((List)((Object)entry.getValue())).size() == 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Instance ");
            sb.append((String)((Object)entry.getKey()));
            sb.append(" is defined in:\n");
            for (AbstractBlockHolder holder : (List)((Object)entry.getValue())) {
                sb.append(" - ");
                FileDefinition file = holder.getDeclaringFile();
                sb.append(file.getEditedFile().getName());
                sb.append(" - line ");
                sb.append(holder.getLine());
                sb.append("\n");
            }
            for (AbstractBlockHolder holder : (List)((Object)entry.getValue())) {
                this.errors.add(new ParsingError(ErrorCode.CO_ALREADY_DEFINED_INSTANCE, holder.getFile(), holder.getLine(), sb.toString()));
            }
        }
    }

    private void backupSourceInformation() {
        for (Map.Entry<BlockInstanceOf, Instance> entry : this.allBlocksToInstances.entrySet()) {
            AbstractBlockHolder holder = entry.getKey();
            SourceReference sr = new SourceReference(entry.getValue(), holder.getFile(), holder.getLine());
            this.objectToSource.put(sr.getModelObject(), sr);
        }
    }
}

