/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;

public class FromInstances {
    public FileDefinition buildFileDefinition(Collection<Instance> rootInstances, File targetFile, boolean addComment, boolean saveRuntimeInformation) {
        FileDefinition result = new FileDefinition(targetFile);
        result.setFileType(2);
        if (addComment) {
            String s = "# File created from an in-memory model,\n# without a binding to existing files.";
            BlockComment initialComment = new BlockComment(result, s);
            result.getBlocks().add(initialComment);
            result.getBlocks().add(new BlockBlank(result, "\n"));
        }
        for (Instance rootInstance : rootInstances) {
            result.getBlocks().addAll(this.buildInstanceOf(result, rootInstance, addComment, saveRuntimeInformation));
        }
        return result;
    }

    private Collection<AbstractBlock> buildInstanceOf(FileDefinition file, Instance rootInstance, boolean addComment, boolean saveRuntimeInformation) {
        ArrayList<AbstractBlock> result = new ArrayList<AbstractBlock>();
        LinkedHashMap<Instance, BlockInstanceOf> instanceToBlock = new LinkedHashMap<Instance, BlockInstanceOf>();
        BlockInstanceOf rootBlock = new BlockInstanceOf(file);
        instanceToBlock.put(rootInstance, rootBlock);
        ArrayList<Instance> toProcess = new ArrayList<Instance>();
        toProcess.add(rootInstance);
        while (!toProcess.isEmpty()) {
            BlockInstanceOf parentBlock;
            BlockProperty p;
            Instance instance = (Instance)toProcess.remove(0);
            BlockInstanceOf currentBlock = (BlockInstanceOf)instanceToBlock.get(instance);
            currentBlock.setName(instance.getComponent().getName());
            if (!Utils.isEmptyOrWhitespaces(instance.getName())) {
                p = new BlockProperty(file, "name", instance.getName());
                currentBlock.getInnerBlocks().add(p);
            }
            if (!instance.channels.isEmpty()) {
                String s = Utils.format(instance.channels, ", ");
                p = new BlockProperty(file, "channels", s);
                currentBlock.getInnerBlocks().add(p);
            }
            for (Map.Entry entry : instance.overriddenExports.entrySet()) {
                p = new BlockProperty(file, (String)entry.getKey(), (String)entry.getValue());
                currentBlock.getInnerBlocks().add(p);
            }
            if (saveRuntimeInformation) {
                p = new BlockProperty(file, "instance-state", instance.getStatus().toString());
                currentBlock.getInnerBlocks().add(p);
                StringBuilder sb = new StringBuilder();
                Iterator<Map.Entry<String, String>> iterator = instance.data.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    sb.append(entry.getKey());
                    sb.append(" = ");
                    sb.append(entry.getValue());
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
                if (sb.length() > 0) {
                    p = new BlockProperty(file, "instance-data", sb.toString());
                    currentBlock.getInnerBlocks().add(p);
                }
            }
            if ((parentBlock = (BlockInstanceOf)instanceToBlock.get(instance.getParent())) != null) {
                parentBlock.getInnerBlocks().add(new BlockBlank(file, ""));
                parentBlock.getInnerBlocks().add(currentBlock);
            }
            for (Instance child : instance.getChildren()) {
                instanceToBlock.put(child, new BlockInstanceOf(file));
                toProcess.add(child);
            }
        }
        result.add(rootBlock);
        result.add(new BlockBlank(file, "\n"));
        return result;
    }
}

