/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.parsing;

import java.io.File;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.utils.Utils;

public abstract class AbstractBlock {
    public static final int PROPERTY = 0;
    public static final int IMPORT = 1;
    public static final int FACET = 2;
    public static final int COMPONENT = 3;
    public static final int COMMENT = 4;
    public static final int BLANK = 5;
    public static final int INSTANCEOF = 6;
    public static final int UNKNOWN = 7;
    private String inlineComment;
    private int line;
    private final FileDefinition declaringFile;

    public AbstractBlock(FileDefinition declaringFile) {
        if (declaringFile == null) {
            throw new IllegalArgumentException("Declaring file cannot be null.");
        }
        this.declaringFile = declaringFile;
    }

    public String getInlineComment() {
        return this.inlineComment;
    }

    public void setInlineComment(String inlineComment) {
        this.inlineComment = Utils.isEmptyOrWhitespaces(inlineComment) ? null : inlineComment;
    }

    public int getLine() {
        return this.line;
    }

    public File getFile() {
        return this.declaringFile.getEditedFile();
    }

    public void setLine(int line) {
        this.line = line;
    }

    public abstract int getInstructionType();

    public FileDefinition getDeclaringFile() {
        return this.declaringFile;
    }
}

