/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.dsl.parsing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.AbstractIgnorableInstruction;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.BlockUnknown;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class FileDefinitionParser {
    static final int P_CODE_YES = 1;
    static final int P_CODE_NO = 2;
    static final int P_CODE_CANCEL = 3;
    private static final char O_CURLY_BRACKET = '{';
    private static final char C_CURLY_BRACKET = '}';
    private static final char SEMI_COLON = ';';
    private final FileDefinition definitionFile;
    private boolean ignoreComments = true;
    private boolean lastLineEndedWithLineBreak = false;
    int currentLineNumber;

    public FileDefinitionParser(File relationsFile, boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        this.currentLineNumber = 0;
        this.definitionFile = new FileDefinition(relationsFile);
    }

    public FileDefinition read() {
        try {
            this.fillIn();
            this.mergeContiguousRegions(this.definitionFile.getBlocks());
        }
        catch (IOException e) {
            this.addModelError(ErrorCode.P_IO_ERROR, this.currentLineNumber, e.getMessage());
        }
        boolean hasFacets = false;
        boolean hasComponents = false;
        boolean hasInstances = false;
        boolean hasImports = false;
        int ignorableBlocksCount = 0;
        for (AbstractBlock block : this.definitionFile.getBlocks()) {
            if (block.getInstructionType() == 3) {
                hasComponents = true;
                continue;
            }
            if (block.getInstructionType() == 2) {
                hasFacets = true;
                continue;
            }
            if (block.getInstructionType() == 6) {
                hasInstances = true;
                continue;
            }
            if (block.getInstructionType() == 1) {
                hasImports = true;
                continue;
            }
            if (!(block instanceof AbstractIgnorableInstruction)) continue;
            ++ignorableBlocksCount;
        }
        if (hasInstances) {
            if (!hasFacets && !hasComponents) {
                this.definitionFile.setFileType(2);
            } else {
                this.addModelError(ErrorCode.P_INVALID_FILE_TYPE, 1);
            }
        } else if (hasFacets || hasComponents) {
            this.definitionFile.setFileType(1);
        } else if (hasImports) {
            this.definitionFile.setFileType(3);
        } else if (ignorableBlocksCount == this.definitionFile.getBlocks().size()) {
            this.addModelError(ErrorCode.P_EMPTY_FILE, 1);
            this.definitionFile.setFileType(4);
        }
        return this.definitionFile;
    }

    int recognizeComponent(String line, BufferedReader br) throws IOException {
        int result = 2;
        String alteredLine = line.trim().toLowerCase();
        if (!(alteredLine.isEmpty() || alteredLine.startsWith(String.valueOf("#")) || this.startsWith(alteredLine, "facet") || this.startsWith(alteredLine, "instance of") || this.startsWith(alteredLine, "import"))) {
            result = this.recognizePropertiesHolder(line, br, new BlockComponent(this.definitionFile));
        }
        return result;
    }

    int recognizeFacet(String line, BufferedReader br) throws IOException {
        int result = 2;
        if (this.startsWith(line, "facet")) {
            String newLine = line.replaceFirst("(?i)\\s*" + Pattern.quote("facet"), "");
            result = this.recognizePropertiesHolder(newLine, br, new BlockFacet(this.definitionFile));
        }
        return result;
    }

    int recognizeInstanceOf(String line, BufferedReader br, AbstractBlockHolder holderInstance) throws IOException {
        BlockInstanceOf newInstance;
        String newLine;
        int result = 2;
        if (this.startsWith(line, "instance of") && (result = this.recognizePropertiesHolder(newLine = line.replaceFirst("(?i)\\s*" + Pattern.quote("instance of"), ""), br, newInstance = new BlockInstanceOf(this.definitionFile))) == 1 && holderInstance != null) {
            this.definitionFile.getBlocks().remove(newInstance);
            holderInstance.getInnerBlocks().add(newInstance);
        }
        return result;
    }

    int recognizeComment(String line, Collection<AbstractBlock> blocks) {
        int result = 2;
        if (line.trim().startsWith("#")) {
            result = 1;
            if (!this.ignoreComments) {
                blocks.add(new BlockComment(this.definitionFile, line));
            }
        }
        return result;
    }

    int recognizeBlankLine(String line, Collection<AbstractBlock> blocks) {
        int result = 2;
        if (Utils.isEmptyOrWhitespaces(line)) {
            result = 1;
            blocks.add(new BlockBlank(this.definitionFile, line));
        }
        return result;
    }

    int recognizeProperty(String line, AbstractBlockHolder holder) {
        int result = 2;
        String[] parts = this.splitFromInlineComment(line);
        String realLine = parts[0].trim();
        String regex = "([^:\\s]+)\\s*:\\s*(.*)$";
        Matcher m = Pattern.compile(regex).matcher(realLine);
        if (m.find()) {
            result = 1;
            BlockProperty block = new BlockProperty(this.definitionFile);
            block.setLine(this.currentLineNumber);
            block.setName(m.group(1));
            if (!m.group(2).endsWith(";")) {
                this.addModelError(ErrorCode.P_PROPERTY_ENDS_WITH_SEMI_COLON);
            }
            block.setValue(m.group(2).replaceFirst(";$", ""));
            block.setInlineComment(parts[1]);
            holder.getInnerBlocks().add(block);
            String escapedLine = block.getValue();
            if (realLine.contains("\"")) {
                escapedLine = escapedLine.replaceAll("\"[^\"]*\"", "");
            }
            if (escapedLine.contains(";")) {
                this.addModelError(ErrorCode.P_ONE_BLOCK_PER_LINE);
            }
        }
        return result;
    }

    int recognizeImport(String line) {
        int result = 2;
        String[] parts = this.splitFromInlineComment(line);
        String realLine = parts[0].trim();
        String regex = "import\\s+([^;]*)";
        Matcher m = Pattern.compile(regex, 2).matcher(realLine);
        if (m.find()) {
            result = 1;
            BlockImport block = new BlockImport(this.definitionFile);
            block.setLine(this.currentLineNumber);
            block.setUri(m.group(1).trim());
            block.setInlineComment(parts[1]);
            this.definitionFile.getBlocks().add(block);
            realLine = realLine.substring(m.end());
            if (!realLine.startsWith(String.valueOf(';'))) {
                this.addModelError(ErrorCode.P_IMPORT_ENDS_WITH_SEMI_COLON);
            } else if (realLine.indexOf(59) < realLine.length() - 1) {
                this.addModelError(ErrorCode.P_ONE_BLOCK_PER_LINE);
            }
        }
        return result;
    }

    String[] splitFromInlineComment(String line) {
        String[] result = new String[]{line, ""};
        int index = line.indexOf("#");
        if (index >= 0) {
            result[0] = line.substring(0, index);
            if (!this.ignoreComments) {
                Matcher m = Pattern.compile("(\\s+)$").matcher(result[0]);
                String prefix = "";
                if (m.find()) {
                    prefix = m.group(1);
                }
                result[1] = prefix + line.substring(index);
            }
            result[0] = result[0].trim();
        }
        return result;
    }

    void mergeContiguousRegions(Collection<AbstractBlock> blocks) {
        AbstractBlock initialInstr = null;
        ArrayList<AbstractBlock> toRemove = new ArrayList<AbstractBlock>();
        StringBuilder sb = new StringBuilder();
        for (AbstractBlock block : blocks) {
            if (initialInstr == null) {
                if (block.getInstructionType() != 4 && block.getInstructionType() != 5) continue;
                AbstractIgnorableInstruction currentInstr = (AbstractIgnorableInstruction)block;
                initialInstr = currentInstr;
                sb = new StringBuilder(currentInstr.getContent());
                continue;
            }
            if (initialInstr.getInstructionType() == block.getInstructionType()) {
                toRemove.add(block);
                sb.append(System.getProperty("line.separator"));
                sb.append(((AbstractIgnorableInstruction)block).getContent());
                continue;
            }
            ((AbstractIgnorableInstruction)initialInstr).setContent(sb.toString());
            initialInstr = null;
        }
        blocks.removeAll(toRemove);
        for (AbstractBlock block : blocks) {
            if (block.getInstructionType() != 3 && block.getInstructionType() != 2) continue;
            this.mergeContiguousRegions(((AbstractBlockHolder)block).getInnerBlocks());
        }
    }

    FileDefinition getFileRelations() {
        return this.definitionFile;
    }

    private int recognizePropertiesHolder(String line, BufferedReader br, AbstractBlockHolder holderInstance) throws IOException {
        int result = 2;
        String[] parts = this.splitFromInlineComment(line);
        String realLine = parts[0].trim();
        AbstractBlockHolder holder = null;
        StringBuilder sb = new StringBuilder();
        boolean endInstructionReached = false;
        boolean foundExtraChars = false;
        for (char c : realLine.toCharArray()) {
            if (c == '{') {
                endInstructionReached = true;
                continue;
            }
            if (!endInstructionReached) {
                sb.append(c);
                continue;
            }
            foundExtraChars = true;
            break;
        }
        if (foundExtraChars) {
            this.addModelError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS);
            result = 3;
        } else if (!endInstructionReached) {
            if (Utils.isEmptyOrWhitespaces(sb.toString()) || sb.toString().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                this.addModelError(ErrorCode.P_O_C_BRACKET_MISSING);
                result = 3;
            } else {
                result = 2;
            }
        } else {
            result = 1;
            holder = holderInstance;
            holder.setName(sb.toString().trim());
            holder.setLine(this.currentLineNumber);
            holder.setInlineComment(parts[1]);
            this.definitionFile.getBlocks().add(holder);
        }
        boolean errorInSubProperties = false;
        if (holder != null) {
            while ((line = this.nextLine(br)) != null && !line.trim().startsWith(String.valueOf('}'))) {
                int code = this.recognizeBlankLine(line, holder.getInnerBlocks());
                if (code == 1 || (code = this.recognizeComment(line, holder.getInnerBlocks())) == 1) continue;
                code = this.recognizeInstanceOf(line, br, holderInstance);
                if (code == 2) {
                    code = this.recognizeProperty(line, holder);
                }
                if (code == 3) {
                    result = 3;
                }
                if (code == 1) continue;
                errorInSubProperties = true;
                break;
            }
        }
        if (errorInSubProperties) {
            if (result == 1) {
                if (holderInstance.getInstructionType() == 6) {
                    this.addModelError(ErrorCode.P_INVALID_PROPERTY_OR_INSTANCE);
                } else {
                    this.addModelError(ErrorCode.P_INVALID_PROPERTY);
                }
            }
            result = 3;
        } else if (result == 1 && line != null && line.trim().startsWith(String.valueOf('}'))) {
            parts = this.splitFromInlineComment(line = line.replaceFirst("\\s*\\}", ""));
            if (!Utils.isEmptyOrWhitespaces(parts[0])) {
                this.addModelError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS);
                result = 3;
            }
            holder.setClosingInlineComment(parts[1]);
        } else if (result == 1) {
            this.addModelError(ErrorCode.P_C_C_BRACKET_MISSING);
        }
        return result;
    }

    String nextLine(BufferedReader br) throws IOException {
        int c = 0;
        StringBuilder sb = new StringBuilder();
        while ((c = br.read()) != -1 && (char)c != '\n') {
            if ((char)c == '\r') continue;
            sb.append((char)c);
        }
        if (sb.length() > 0) {
            this.lastLineEndedWithLineBreak = c != -1;
        }
        String line = c == -1 && sb.length() == 0 ? null : sb.toString();
        ++this.currentLineNumber;
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn() throws IOException {
        BufferedReader br = null;
        FileInputStream in = null;
        try {
            String line;
            in = new FileInputStream(this.definitionFile.getEditedFile());
            br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((line = this.nextLine(br)) != null) {
                int code = this.recognizeBlankLine(line, this.definitionFile.getBlocks());
                if (code == 1 || (code = this.recognizeComment(line, this.definitionFile.getBlocks())) == 1) continue;
                code = this.recognizeImport(line);
                if (code == 3) break;
                if (code == 1) continue;
                code = this.recognizeFacet(line, br);
                if (code == 3) break;
                if (code == 1) continue;
                code = this.recognizeInstanceOf(line, br, null);
                if (code == 3) break;
                if (code == 1) continue;
                code = this.recognizeComponent(line, br);
                if (code != 1) {
                    this.definitionFile.getBlocks().add(new BlockUnknown(this.definitionFile, line));
                }
                if (code == 3) break;
                if (code != 2) continue;
                this.addModelError(ErrorCode.P_UNRECOGNIZED_BLOCK);
            }
            if (line == null && this.lastLineEndedWithLineBreak) {
                this.definitionFile.getBlocks().add(new BlockBlank(this.definitionFile, ""));
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(br);
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly(br);
        Utils.closeQuietly(in);
    }

    private void addModelError(ErrorCode errorCode) {
        ParsingError me = new ParsingError(errorCode, this.definitionFile.getEditedFile(), this.currentLineNumber);
        this.definitionFile.getParsingErrors().add(me);
    }

    private void addModelError(ErrorCode errorCode, int line) {
        this.addModelError(errorCode, line, null);
    }

    private void addModelError(ErrorCode errorCode, int line, String details) {
        ParsingError me = new ParsingError(errorCode, this.definitionFile.getEditedFile(), line, details);
        this.definitionFile.getParsingErrors().add(me);
    }

    private boolean startsWith(String line, String keyword) {
        return line.trim().matches("(?i)^" + keyword + "((\\s.*)|$)");
    }
}

