/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RoboconfLogFormatter
extends Formatter {
    private static final int LEVEL_SPAN = RoboconfLogFormatter.findMaxLevelLength();
    private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

    @Override
    public String format(LogRecord record) {
        int i;
        int totalSpaces = LEVEL_SPAN - record.getLevel().toString().length();
        StringBuilder sbLevel = new StringBuilder();
        for (i = 0; i < totalSpaces / 2; ++i) {
            sbLevel.append(" ");
        }
        sbLevel.append(record.getLevel());
        for (i = sbLevel.toString().length(); i < LEVEL_SPAN; ++i) {
            sbLevel.append(" ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ").append(this.df.format(new Date(record.getMillis()))).append(" ]");
        sb.append("[ ").append((CharSequence)sbLevel).append(" ] ");
        sb.append(record.getSourceClassName()).append("#");
        sb.append(record.getSourceMethodName());
        sb.append("\n");
        sb.append(this.formatMessage(record));
        sb.append("\n");
        return sb.toString();
    }

    static int findMaxLevelLength() {
        Level[] levels = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.SEVERE, Level.WARNING};
        int result = -1;
        for (Level level : levels) {
            result = Math.max(result, level.toString().length());
        }
        return result;
    }
}

