/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.utils.Utils;

public class ApplicationDescriptor {
    public static final String APPLICATION_NAME = "application-name";
    public static final String APPLICATION_DESCRIPTION = "application-description";
    public static final String APPLICATION_TPL_NAME = "template-name";
    public static final String APPLICATION_TPL_QUALIFIER = "template-qualifier";
    private String name;
    private String description;
    private String templateName;
    private String templateQualifier;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateQualifier() {
        return this.templateQualifier;
    }

    public void setTemplateQualifier(String templateQualifier) {
        this.templateQualifier = templateQualifier;
    }

    public static ApplicationDescriptor load(Properties properties) {
        ApplicationDescriptor result = new ApplicationDescriptor();
        result.name = properties.getProperty(APPLICATION_NAME, null);
        result.description = properties.getProperty(APPLICATION_DESCRIPTION, null);
        result.templateName = properties.getProperty(APPLICATION_TPL_NAME, null);
        result.templateQualifier = properties.getProperty(APPLICATION_TPL_QUALIFIER, null);
        return result;
    }

    public static ApplicationDescriptor load(File f) throws IOException {
        Properties properties = Utils.readPropertiesFile(f);
        return ApplicationDescriptor.load(properties);
    }

    public static void save(File f, Application app) throws IOException {
        Properties properties = new Properties();
        if (!Utils.isEmptyOrWhitespaces(app.getDisplayName())) {
            properties.setProperty(APPLICATION_NAME, app.getDisplayName());
        }
        if (!Utils.isEmptyOrWhitespaces(app.getDescription())) {
            properties.setProperty(APPLICATION_DESCRIPTION, app.getDescription());
        }
        if (app.getTemplate() != null) {
            if (!Utils.isEmptyOrWhitespaces(app.getTemplate().getName())) {
                properties.setProperty(APPLICATION_TPL_NAME, app.getTemplate().getName());
            }
            if (!Utils.isEmptyOrWhitespaces(app.getTemplate().getQualifier())) {
                properties.setProperty(APPLICATION_TPL_QUALIFIER, app.getTemplate().getQualifier());
            }
        }
        Utils.writePropertiesFile(properties, f);
    }
}

