/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.utils.Utils;

public class ApplicationTemplateDescriptor {
    public static final String APPLICATION_NAME = "application-name";
    public static final String APPLICATION_QUALIFIER = "application-qualifier";
    public static final String APPLICATION_DESCRIPTION = "application-description";
    public static final String APPLICATION_DSL_ID = "application-dsl-id";
    public static final String APPLICATION_GRAPH_EP = "graph-entry-point";
    public static final String APPLICATION_INSTANCES_EP = "instance-entry-point";
    public static final String APPLICATION_EXTERNAL_EXPORTS_PREFIX = "exports-prefix";
    public static final String APPLICATION_EXTERNAL_EXPORTS = "exports";
    public static final String APPLICATION_EXTERNAL_EXPORTS_AS = "as";
    private String name;
    private String description;
    private String qualifier;
    private String graphEntryPoint;
    private String instanceEntryPoint;
    private String dslId;
    private String externalExportsPrefix;
    public final Map<String, String> externalExports = new HashMap<String, String>();
    public final Set<String> invalidExternalExports = new HashSet<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getExternalExportsPrefix() {
        return this.externalExportsPrefix;
    }

    public void setExternalExportsPrefix(String externalExportsId) {
        this.externalExportsPrefix = externalExportsId;
    }

    public String getGraphEntryPoint() {
        return this.graphEntryPoint;
    }

    public void setGraphEntryPoint(String graphEntryPoint) {
        this.graphEntryPoint = graphEntryPoint;
    }

    public String getInstanceEntryPoint() {
        return this.instanceEntryPoint;
    }

    public void setInstanceEntryPoint(String instanceEntryPoint) {
        this.instanceEntryPoint = instanceEntryPoint;
    }

    public String getDslId() {
        return this.dslId;
    }

    public void setDslId(String dslId) {
        this.dslId = dslId;
    }

    public static ApplicationTemplateDescriptor load(Properties properties) {
        ApplicationTemplateDescriptor result = new ApplicationTemplateDescriptor();
        result.name = properties.getProperty(APPLICATION_NAME, null);
        result.description = properties.getProperty(APPLICATION_DESCRIPTION, null);
        result.qualifier = properties.getProperty(APPLICATION_QUALIFIER, null);
        result.graphEntryPoint = properties.getProperty(APPLICATION_GRAPH_EP, null);
        result.instanceEntryPoint = properties.getProperty(APPLICATION_INSTANCES_EP, null);
        result.dslId = properties.getProperty(APPLICATION_DSL_ID, null);
        result.externalExportsPrefix = properties.getProperty(APPLICATION_EXTERNAL_EXPORTS_PREFIX, null);
        Pattern pattern = Pattern.compile("([^=\\s]+)\\s+as\\s+([^=\\s]+)", 2);
        String rawExports = properties.getProperty(APPLICATION_EXTERNAL_EXPORTS, "");
        for (String rawExport : Utils.splitNicely(rawExports, ",")) {
            Matcher m = pattern.matcher(rawExport);
            if (m.matches()) {
                result.externalExports.put(m.group(1), m.group(2));
                continue;
            }
            result.invalidExternalExports.add(rawExport);
        }
        return result;
    }

    public static ApplicationTemplateDescriptor load(File f) throws IOException {
        Properties properties = Utils.readPropertiesFile(f);
        if (properties.get("fail.read") != null) {
            throw new IOException("This is for test purpose...");
        }
        return ApplicationTemplateDescriptor.load(properties);
    }

    public static void save(File f, ApplicationTemplateDescriptor descriptor) throws IOException {
        Properties properties = new Properties();
        if (descriptor.name != null) {
            properties.setProperty(APPLICATION_NAME, descriptor.name);
        }
        if (descriptor.qualifier != null) {
            properties.setProperty(APPLICATION_QUALIFIER, descriptor.qualifier);
        }
        if (descriptor.dslId != null) {
            properties.setProperty(APPLICATION_DSL_ID, descriptor.dslId);
        }
        if (descriptor.description != null) {
            properties.setProperty(APPLICATION_DESCRIPTION, descriptor.description);
        }
        if (descriptor.graphEntryPoint != null) {
            properties.setProperty(APPLICATION_GRAPH_EP, descriptor.graphEntryPoint);
        }
        if (descriptor.instanceEntryPoint != null) {
            properties.setProperty(APPLICATION_INSTANCES_EP, descriptor.instanceEntryPoint);
        }
        if (descriptor.externalExportsPrefix != null) {
            properties.setProperty(APPLICATION_EXTERNAL_EXPORTS_PREFIX, descriptor.externalExportsPrefix);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = descriptor.externalExports.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append(entry.getKey());
            sb.append(" ");
            sb.append(APPLICATION_EXTERNAL_EXPORTS_AS);
            sb.append(" ");
            sb.append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        if (sb.length() > 0) {
            properties.setProperty(APPLICATION_EXTERNAL_EXPORTS, sb.toString());
        }
        Utils.writePropertiesFile(properties, f);
    }
}

