/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.RecipesValidator;
import net.roboconf.core.model.TargetValidator;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;

public final class RuntimeModelValidator {
    private RuntimeModelValidator() {
    }

    public static Collection<ModelError> validate(Component component) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(component.getName())) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_COMPONENT_NAME, component));
        } else if (!component.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_COMPONENT_NAME, component, "Component name: " + component));
        } else if (component.getName().contains(".")) {
            errors.add(new ModelError(ErrorCode.RM_DOT_IS_NOT_ALLOWED, component, "Component name: " + component));
        }
        String installerName = ComponentHelpers.findComponentInstaller(component);
        if (Utils.isEmptyOrWhitespaces(installerName)) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, component, "Component name: " + component));
        } else if (!installerName.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_COMPONENT_INSTALLER, component, "Component name: " + component));
        } else if (ComponentHelpers.findAllAncestors(component).isEmpty() && !"target".equals(installerName)) {
            errors.add(new ModelError(ErrorCode.RM_ROOT_INSTALLER_MUST_BE_TARGET, component, "Component name: " + component));
        }
        for (Object exportedVariable : component.exportedVariables.values()) {
            String exportedVarName = ((ExportedVariable)exportedVariable).getName();
            if (Utils.isEmptyOrWhitespaces(exportedVarName)) {
                errors.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, component, "Variable name: " + exportedVarName));
            } else if (!exportedVarName.matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, component, "Variable name: " + exportedVarName));
            }
            if (!((ExportedVariable)exportedVariable).isRandom()) continue;
            if (((ExportedVariable)exportedVariable).getRandomKind() == null) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_RANDOM_KIND, component, "Unknown kind: " + ((ExportedVariable)exportedVariable).getRawKind()));
            }
            if (((ExportedVariable)exportedVariable).getValue() == null) continue;
            errors.add(new ModelError(ErrorCode.RM_NO_VALUE_FOR_RANDOM, component, "Variable name: " + ((ExportedVariable)exportedVariable).getName()));
        }
        Map<String, String> allExportedVariables = ComponentHelpers.findAllExportedVariables(component);
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
            String varName = var.getName();
            String patternForImports = "[a-zA-Z_](\\w|-|\\.)*";
            patternForImports = patternForImports + "(\\.\\*)?";
            if (Utils.isEmptyOrWhitespaces(varName)) {
                errors.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, component, "Variable name: " + varName));
            } else if (!varName.matches(patternForImports)) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, component, "Variable name: " + varName));
            }
            if (var.isOptional() || !allExportedVariables.containsKey(varName)) continue;
            errors.add(new ModelError(ErrorCode.RM_COMPONENT_IMPORTS_EXPORTS, component, "Variable name: " + varName));
        }
        String errorMsg = ComponentHelpers.searchForInheritanceCycle(component);
        if (errorMsg != null) {
            errors.add(new ModelError(ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, component, errorMsg));
        }
        if ((errorMsg = ComponentHelpers.searchForLoop(component)) != null && errorMsg.startsWith(component.getName())) {
            errors.add(new ModelError(ErrorCode.RM_CYCLE_IN_COMPONENTS, component, errorMsg));
        }
        return errors;
    }

    public static Collection<ModelError> validate(Facet facet) {
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(facet.getName())) {
            result.add(new ModelError(ErrorCode.RM_EMPTY_FACET_NAME, facet));
        } else if (!facet.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(new ModelError(ErrorCode.RM_INVALID_FACET_NAME, facet, "Facet name: " + facet));
        } else if (facet.getName().contains(".")) {
            result.add(new ModelError(ErrorCode.RM_DOT_IS_NOT_ALLOWED, facet, "Facet name: " + facet));
        }
        for (String exportedVarName : facet.exportedVariables.keySet()) {
            if (Utils.isEmptyOrWhitespaces(exportedVarName)) {
                result.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, facet, "Variable name: " + exportedVarName));
                continue;
            }
            if (exportedVarName.matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
            result.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, facet, "Variable name: " + exportedVarName));
        }
        String errorMsg = ComponentHelpers.searchForInheritanceCycle(facet);
        if (errorMsg != null) {
            result.add(new ModelError(ErrorCode.RM_CYCLE_IN_FACETS_INHERITANCE, facet, errorMsg));
        }
        return result;
    }

    public static Collection<ModelError> validate(Graphs graphs, File projectDirectory) {
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        for (Component c : ComponentHelpers.findAllComponents(graphs)) {
            File componentDirectory = ResourceUtils.findInstanceResourcesDirectory(projectDirectory, c);
            if (!componentDirectory.exists()) {
                ModelError error = new ModelError(ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, c);
                error.setDetails("Component name: " + c.getName());
                result.add(error);
                continue;
            }
            if (ComponentHelpers.isTarget(c)) {
                result.addAll(TargetValidator.parseTargetProperties(projectDirectory, c));
                continue;
            }
            result.addAll(RecipesValidator.validateComponentRecipes(projectDirectory, c));
        }
        return result;
    }

    public static Collection<ModelError> validate(Graphs graphs) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (graphs.getRootComponents().isEmpty()) {
            errors.add(new ModelError(ErrorCode.RM_NO_ROOT_COMPONENT, graphs));
        }
        for (Component rootComponent : graphs.getRootComponents()) {
            if (ComponentHelpers.findAllAncestors(rootComponent).isEmpty()) continue;
            errors.add(new ModelError(ErrorCode.RM_NOT_A_ROOT_COMPONENT, rootComponent, "Component name: " + rootComponent));
        }
        HashMap<String, Boolean> importedVariableNameToExported = new HashMap<String, Boolean>();
        HashMap<String, ArrayList<Component>> importedVariableToImporters = new HashMap<String, ArrayList<Component>>();
        for (Component component : ComponentHelpers.findAllComponents(graphs)) {
            errors.addAll(RuntimeModelValidator.validate(component));
            for (Facet facet : ComponentHelpers.findAllFacets(component)) {
                errors.addAll(RuntimeModelValidator.validate(facet));
            }
            for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
                ArrayList<Component> importers;
                if (var.isExternal()) continue;
                String importedVariableName = var.getName();
                if (!importedVariableNameToExported.containsKey(importedVariableName)) {
                    importedVariableNameToExported.put(importedVariableName, Boolean.FALSE);
                }
                if ((importers = (ArrayList<Component>)importedVariableToImporters.get(importedVariableName)) == null) {
                    importers = new ArrayList<Component>();
                }
                importers.add(component);
                importedVariableToImporters.put(importedVariableName, importers);
            }
            for (String exportedVariableName : ComponentHelpers.findAllExportedVariables(component).keySet()) {
                importedVariableNameToExported.put(exportedVariableName, Boolean.TRUE);
                String prefix = VariableHelpers.parseVariableName(exportedVariableName).getKey();
                importedVariableNameToExported.put((String)prefix + "." + "*", Boolean.TRUE);
            }
        }
        HashSet<Object> facetVariables = new HashSet<Object>();
        for (Facet facet : graphs.getFacetNameToFacet().values()) {
            facetVariables.addAll(facet.exportedVariables.keySet());
            facetVariables.add(facet.getName() + "." + "*");
        }
        for (Map.Entry entry : importedVariableNameToExported.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            ErrorCode errorCode = ErrorCode.RM_UNRESOLVABLE_VARIABLE;
            if (facetVariables.contains(entry.getKey())) {
                errorCode = ErrorCode.RM_UNRESOLVABLE_FACET_VARIABLE;
            }
            for (Component component : (List)importedVariableToImporters.get(entry.getKey())) {
                errors.add(new ModelError(errorCode, component, "Variable name: " + (String)entry.getKey()));
            }
        }
        for (Facet facet : graphs.getFacetNameToFacet().values()) {
            if (!facet.getAssociatedComponents().isEmpty()) continue;
            if (facet.getChildren().isEmpty()) {
                errors.add(new ModelError(ErrorCode.RM_ORPHAN_FACET, facet, "Facet name: " + facet));
            } else {
                errors.add(new ModelError(ErrorCode.RM_ORPHAN_FACET_WITH_CHILDREN, facet, "Facet name: " + facet));
            }
            for (AbstractType t : facet.getChildren()) {
                if (!(t instanceof Component)) continue;
                errors.add(new ModelError(ErrorCode.RM_UNREACHABLE_COMPONENT, t, "Component name: " + t));
            }
        }
        return errors;
    }

    public static Collection<ModelError> validate(Instance instance) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(instance.getName())) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_INSTANCE_NAME, instance));
        } else if (!instance.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_INSTANCE_NAME, instance, "Instance name: " + instance.getName()));
        }
        if (instance.getComponent() == null) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, instance));
        }
        if (instance.getComponent() != null) {
            ErrorCode errorCode = null;
            Collection<Component> ancestors = ComponentHelpers.findAllAncestors(instance.getComponent());
            if (instance.getParent() == null && !ancestors.isEmpty()) {
                errorCode = ErrorCode.RM_MISSING_INSTANCE_PARENT;
            } else if (!(instance.getParent() == null || ancestors.contains(instance.getParent().getComponent()) && ComponentHelpers.findAllChildren(instance.getParent().getComponent()).contains(instance.getComponent()))) {
                errorCode = ErrorCode.RM_INVALID_INSTANCE_PARENT;
            }
            if (errorCode != null) {
                StringBuilder sb = new StringBuilder("One of the following parent was expected: ");
                Iterator<Component> iterator = ancestors.iterator();
                while (iterator.hasNext()) {
                    sb.append(iterator.next().getName());
                    if (!iterator.hasNext()) continue;
                    sb.append(", ");
                }
                errors.add(new ModelError(errorCode, instance, sb.toString()));
            }
        }
        HashMap<String, HashSet<String>> localNameToFullNames = new HashMap<String, HashSet<String>>();
        Set<String> inheritedVarNames = instance.getComponent() != null ? ComponentHelpers.findAllExportedVariables(instance.getComponent()).keySet() : new HashSet<String>(0);
        for (String string : inheritedVarNames) {
            String localName = VariableHelpers.parseVariableName(string).getValue();
            HashSet<String> fullNames = (HashSet<String>)localNameToFullNames.get(localName);
            if (fullNames == null) {
                fullNames = new HashSet<String>();
            }
            fullNames.add(string);
            localNameToFullNames.put(localName, fullNames);
        }
        for (Map.Entry entry : instance.overriddenExports.entrySet()) {
            if (inheritedVarNames.contains(entry.getKey())) continue;
            Set fullNames = (Set)localNameToFullNames.get(entry.getKey());
            if (fullNames == null) {
                errors.add(new ModelError(ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, instance, "Variable name: " + (String)entry.getKey()));
                continue;
            }
            if (fullNames.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Variable '");
            sb.append((String)entry.getKey());
            sb.append("' overrides ");
            Iterator it = fullNames.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            errors.add(new ModelError(ErrorCode.RM_AMBIGUOUS_OVERRIDING, instance, sb.toString()));
        }
        RuntimeModelValidator.randomVariablesTrickForValidation(instance, true);
        for (Map.Entry entry : InstanceHelpers.findAllExportedVariables(instance).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!Utils.isEmptyOrWhitespaces(value) || "ip".equalsIgnoreCase(name) || name.toLowerCase().endsWith(".ip")) continue;
            errors.add(new ModelError(ErrorCode.RM_MISSING_VARIABLE_VALUE, instance, "Variable name: " + name));
        }
        RuntimeModelValidator.randomVariablesTrickForValidation(instance, false);
        return errors;
    }

    public static Collection<ModelError> validate(Collection<Instance> instances) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        for (Instance i : instances) {
            errors.addAll(RuntimeModelValidator.validate(i));
        }
        return errors;
    }

    public static Collection<ModelError> validate(ApplicationTemplate app) {
        Map<String, String> allExports;
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(app.getName())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_NAME, app));
        } else if (!app.getName().matches("[a-zA-Z_](\\w|[-.() ])*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_NAME, app));
        }
        if (Utils.isEmptyOrWhitespaces(app.getQualifier())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, app));
        }
        if (app.getGraphs() == null) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_GRAPHS, app));
            allExports = new HashMap<String, String>(0);
        } else {
            errors.addAll(RuntimeModelValidator.validate(app.getGraphs()));
            allExports = ComponentHelpers.findAllExportedVariables(app.getGraphs());
        }
        if (!app.externalExports.isEmpty()) {
            if (Utils.isEmptyOrWhitespaces(app.getExternalExportsPrefix())) {
                errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, app));
            } else if (!app.getExternalExportsPrefix().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_EXPORT_PREFIX, app));
            }
        }
        HashSet<String> alreadySeen = new HashSet<String>();
        for (Map.Entry<String, String> entry : app.externalExports.entrySet()) {
            if (!entry.getKey().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, app, "Variable name: " + entry.getKey()));
            }
            if (!allExports.containsKey(entry.getKey())) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_EXTERNAL_EXPORT, app, "Variable name: " + entry.getKey()));
            }
            if (!entry.getValue().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, app, "Variable name: " + entry.getValue()));
            }
            if (alreadySeen.contains(entry.getValue())) {
                errors.add(new ModelError(ErrorCode.RM_ALREADY_DEFINED_EXTERNAL_EXPORT, app, "Variable name: " + entry.getValue()));
                continue;
            }
            alreadySeen.add(entry.getValue());
        }
        errors.addAll(RuntimeModelValidator.validate(InstanceHelpers.getAllInstances(app)));
        return errors;
    }

    public static Collection<ModelError> validate(ApplicationTemplateDescriptor descriptor) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(descriptor.getName())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_NAME, descriptor));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getQualifier())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, descriptor));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getDslId())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_DSL_ID, descriptor));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getGraphEntryPoint())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_GEP, descriptor));
        }
        if (!descriptor.invalidExternalExports.isEmpty()) {
            errors.add(new ModelError(ErrorCode.PROJ_INVALID_EXTERNAL_EXPORTS, descriptor));
        }
        for (Map.Entry<String, String> entry : descriptor.externalExports.entrySet()) {
            if (!entry.getKey().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, descriptor, "Variable name: " + entry.getKey()));
            }
            if (entry.getValue().matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
            errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, descriptor, "Variable name: " + entry.getValue()));
        }
        return errors;
    }

    private static void randomVariablesTrickForValidation(Instance instance, boolean set) {
        String trickValue = "@# --- #@";
        Map exportedVariables = instance.getComponent() != null ? instance.getComponent().exportedVariables : new HashMap(0);
        for (ExportedVariable var : exportedVariables.values()) {
            if (!var.isRandom()) continue;
            String overriddenExport = instance.overriddenExports.get(var.getName());
            if (set && overriddenExport == null) {
                instance.overriddenExports.put(var.getName(), "@# --- #@");
                continue;
            }
            if (set || !Objects.equals("@# --- #@", overriddenExport)) continue;
            instance.overriddenExports.remove(var.getName());
        }
    }
}

