/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.File;
import java.text.Normalizer;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;

public abstract class AbstractApplication {
    protected final Collection<Instance> rootInstances = new CopyOnWriteArraySet<Instance>();
    protected String name;
    protected String displayName;
    protected String description;
    protected File directory;

    public Collection<Instance> getRootInstances() {
        return this.rootInstances;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (name == null) {
            this.name = null;
            this.displayName = null;
        } else if (Utils.isEmptyOrWhitespaces(name)) {
            this.displayName = name.trim();
            this.name = name.trim();
        } else {
            this.displayName = name.trim();
            String temp = Normalizer.normalize(name, Normalizer.Form.NFD);
            Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
            this.name = pattern.matcher(temp).replaceAll("").trim();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public abstract Graphs getGraphs();

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.name;
    }
}

