/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.roboconf.core.model.beans.ExportedVariable;

public abstract class AbstractType
implements Serializable {
    private static final long serialVersionUID = 6426303830149882558L;
    public final Map<String, ExportedVariable> exportedVariables = new TreeMap<String, ExportedVariable>();
    protected String name;
    protected final Collection<AbstractType> children = new HashSet<AbstractType>(0);
    protected final Collection<AbstractType> ancestors = new HashSet<AbstractType>(0);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && Objects.equals(this.name, ((AbstractType)obj).getName());
    }

    public int hashCode() {
        return this.name == null ? 31 : this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public void addChild(AbstractType type) {
        this.children.add(type);
        type.ancestors.add(this);
    }

    public Collection<AbstractType> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Collection<AbstractType> getAncestors() {
        return Collections.unmodifiableCollection(this.ancestors);
    }

    public void addExportedVariable(ExportedVariable var) {
        this.exportedVariables.put(var.getName(), var);
    }
}

