/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Graphs;

public class ApplicationTemplate
extends AbstractApplication
implements Serializable {
    private static final long serialVersionUID = -4753958407033243184L;
    private String qualifier;
    private String dslId;
    private String externalExportsPrefix;
    private Graphs graphs;
    private final List<Application> associatedApplications = new ArrayList<Application>();
    public final Map<String, String> externalExports = new HashMap<String, String>();

    public ApplicationTemplate() {
    }

    public ApplicationTemplate(String name) {
        this.setName(name);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getDslId() {
        return this.dslId;
    }

    public void setDslId(String dslId) {
        this.dslId = dslId;
    }

    @Override
    public Graphs getGraphs() {
        return this.graphs;
    }

    public void setGraphs(Graphs graphs) {
        this.graphs = graphs;
    }

    public String getExternalExportsPrefix() {
        return this.externalExportsPrefix;
    }

    public void setExternalExportsPrefix(String externalExportsPrefix) {
        this.externalExportsPrefix = externalExportsPrefix;
    }

    public boolean equals(Object obj) {
        return obj instanceof ApplicationTemplate && Objects.equals(this.name, ((ApplicationTemplate)obj).getName()) && Objects.equals(this.qualifier, ((ApplicationTemplate)obj).getQualifier());
    }

    public int hashCode() {
        int i1 = this.name == null ? 29 : this.name.hashCode();
        int i2 = this.qualifier == null ? 11 : this.qualifier.hashCode();
        return i1 * i2;
    }

    public ApplicationTemplate name(String name) {
        this.name = name;
        return this;
    }

    public ApplicationTemplate qualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public ApplicationTemplate description(String description) {
        this.description = description;
        return this;
    }

    public ApplicationTemplate dslId(String dslId) {
        this.dslId = dslId;
        return this;
    }

    public ApplicationTemplate graphs(Graphs graphs) {
        this.graphs = graphs;
        return this;
    }

    public ApplicationTemplate directory(File directory) {
        this.directory = directory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Application> getAssociatedApplications() {
        List<Application> list = this.associatedApplications;
        synchronized (list) {
            return Collections.unmodifiableList(this.associatedApplications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associateApplication(Application app) {
        List<Application> list = this.associatedApplications;
        synchronized (list) {
            this.associatedApplications.add(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeApplicationAssocation(Application app) {
        List<Application> list = this.associatedApplications;
        synchronized (list) {
            this.associatedApplications.remove(app);
        }
    }
}

