/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.RoboconfError;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.utils.Utils;

public final class RoboconfErrorHelpers {
    private RoboconfErrorHelpers() {
    }

    public static boolean containsCriticalErrors(Collection<? extends RoboconfError> errors) {
        RoboconfError error;
        boolean result = false;
        Iterator<? extends RoboconfError> iterator = errors.iterator();
        while (iterator.hasNext() && !(result = (error = iterator.next()).getErrorCode().getLevel() == ErrorCode.ErrorLevel.SEVERE)) {
        }
        return result;
    }

    public static Collection<RoboconfError> findWarnings(Collection<? extends RoboconfError> errors) {
        ArrayList<RoboconfError> result = new ArrayList<RoboconfError>();
        for (RoboconfError roboconfError : errors) {
            if (roboconfError.getErrorCode().getLevel() != ErrorCode.ErrorLevel.WARNING) continue;
            result.add(roboconfError);
        }
        return result;
    }

    public static List<String> extractAndFormatWarnings(Collection<? extends RoboconfError> errors) {
        ArrayList<String> result = new ArrayList<String>();
        for (RoboconfError warning : RoboconfErrorHelpers.findWarnings(errors)) {
            StringBuilder sb = new StringBuilder();
            sb.append(warning.getErrorCode().getMsg());
            if (!Utils.isEmptyOrWhitespaces(warning.getDetails())) {
                sb.append(" " + warning.getDetails());
            }
            result.add(sb.toString());
        }
        return result;
    }

    public static List<RoboconfError> resolveErrorsWithLocation(RuntimeModelIo.ApplicationLoadResult alr) {
        ArrayList<RoboconfError> result = new ArrayList<RoboconfError>();
        Iterator<RoboconfError> iterator = alr.getLoadErrors().iterator();
        while (iterator.hasNext()) {
            RoboconfError error;
            RoboconfError errorToAdd = error = iterator.next();
            if (error instanceof ModelError) {
                Object modelObject = ((ModelError)error).getModelObject();
                SourceReference sr = alr.getObjectToSource().get(modelObject);
                if (sr != null) {
                    errorToAdd = new ParsingError(error.getErrorCode(), sr.getSourceFile(), sr.getLine(), error.getDetails());
                }
            }
            result.add(errorToAdd);
        }
        return result;
    }

    public static void filterErrorsForRecipes(RuntimeModelIo.ApplicationLoadResult alr) {
        RoboconfErrorHelpers.filterErrorsForRecipes(alr.getLoadErrors());
    }

    public static void filterErrorsForRecipes(Collection<? extends RoboconfError> errors) {
        RoboconfErrorHelpers.filterErrors(errors, ErrorCode.RM_ROOT_INSTALLER_MUST_BE_TARGET, ErrorCode.RM_UNRESOLVABLE_FACET_VARIABLE, ErrorCode.RM_UNREACHABLE_COMPONENT, ErrorCode.RM_ORPHAN_FACET, ErrorCode.RM_ORPHAN_FACET_WITH_CHILDREN);
    }

    public static void filterErrors(Collection<? extends RoboconfError> errors, ErrorCode ... errorCodes) {
        ArrayList<ErrorCode> codesToSkip = new ArrayList<ErrorCode>();
        if (errorCodes != null) {
            codesToSkip.addAll(Arrays.asList(errorCodes));
        }
        ArrayList<RoboconfError> toRemove = new ArrayList<RoboconfError>();
        for (RoboconfError roboconfError : errors) {
            if (!codesToSkip.contains((Object)roboconfError.getErrorCode())) continue;
            toRemove.add(roboconfError);
        }
        errors.removeAll(toRemove);
    }
}

