/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;

public final class VariableHelpers {
    private VariableHelpers() {
    }

    public static Map.Entry<String, String> parseVariableName(String variableName) {
        String componentOrFacetName = "";
        String simpleName = variableName;
        int index = variableName.indexOf(46);
        if (index >= 0) {
            componentOrFacetName = variableName.substring(0, index).trim();
            simpleName = variableName.substring(index + 1).trim();
        }
        return new AbstractMap.SimpleEntry<String, String>(componentOrFacetName, simpleName);
    }

    public static Map.Entry<String, String> parseExportedVariable(String exportedVariable) {
        int index = exportedVariable.indexOf(61);
        String varName = exportedVariable;
        String defaultValue = null;
        if (index > 0) {
            varName = exportedVariable.substring(0, index).trim();
            defaultValue = exportedVariable.substring(index + 1).trim();
        }
        return new AbstractMap.SimpleEntry<String, Object>(varName, defaultValue);
    }

    public static Map<String, ExportedVariable> parseExportedVariables(String line) {
        Pattern randomPattern = Pattern.compile("random\\[([^]]*)\\](.*)", 2);
        Pattern varPattern = Pattern.compile("([^,=]+)(\\s*=\\s*(\"([^\",]+)\"|([^,]+)))?");
        LinkedHashMap<String, ExportedVariable> result = new LinkedHashMap<String, ExportedVariable>();
        Matcher varMatcher = varPattern.matcher(line);
        while (varMatcher.find()) {
            String key = varMatcher.group(1).trim();
            if (Utils.isEmptyOrWhitespaces(key)) continue;
            String value = null;
            if (varMatcher.group(3) != null) {
                value = varMatcher.group(5) != null ? varMatcher.group(5).trim() : varMatcher.group(4);
            }
            ExportedVariable var = new ExportedVariable();
            Matcher m = randomPattern.matcher(key);
            if (m.matches()) {
                var.setRandom(true);
                var.setRawKind(m.group(1));
                key = m.group(2).trim();
            }
            var.setName(key.trim());
            if (value != null) {
                var.setValue(value);
            }
            result.put(var.getName(), var);
        }
        return result;
    }

    public static Set<String> findPrefixesForExportedVariables(Instance instance) {
        HashSet<String> result = new HashSet<String>();
        for (String exportedVariableName : InstanceHelpers.findAllExportedVariables(instance).keySet()) {
            result.add(VariableHelpers.parseVariableName(exportedVariableName).getKey());
        }
        return result;
    }

    public static Set<String> findPrefixesForImportedVariables(Instance instance) {
        HashSet<String> result = new HashSet<String>();
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(instance.getComponent()).values()) {
            result.add(VariableHelpers.parseVariableName(var.getName()).getKey());
        }
        return result;
    }

    public static Set<String> findPrefixesForMandatoryImportedVariables(Instance instance) {
        HashSet<String> result = new HashSet<String>();
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(instance.getComponent()).values()) {
            if (var.isOptional()) continue;
            result.add(VariableHelpers.parseVariableName(var.getName()).getKey());
        }
        return result;
    }

    public static Set<String> findPrefixesForExternalImports(AbstractApplication app) {
        TreeSet<String> result = new TreeSet<String>();
        for (Component c : ComponentHelpers.findAllComponents(app)) {
            for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(c).values()) {
                if (!var.isExternal()) continue;
                String prefix = VariableHelpers.parseVariableName(var.getName()).getKey();
                result.add(prefix);
            }
        }
        return result;
    }

    static void updateNetworkVariables(Map<String, String> instanceExports, String ipAddress) {
        HashSet<String> keysToUpdate = new HashSet<String>();
        for (Map.Entry<String, String> entry : instanceExports.entrySet()) {
            String suffix = VariableHelpers.parseVariableName(entry.getKey()).getValue();
            if (!"ip".equalsIgnoreCase(suffix)) continue;
            keysToUpdate.add(entry.getKey());
        }
        for (String key : keysToUpdate) {
            instanceExports.put(key, ipAddress);
        }
    }
}

