/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;

public final class DockerfileParser {
    private DockerfileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DockerCommand> dockerfileToCommandList(File dockerfile) throws IOException {
        ArrayList<DockerCommand> result = new ArrayList<DockerCommand>();
        FileInputStream in = new FileInputStream(dockerfile);
        Logger logger = Logger.getLogger(DockerfileParser.class.getName());
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                DockerCommand cmd = DockerCommand.guess(line);
                if (cmd != null) {
                    result.add(cmd);
                    continue;
                }
                logger.fine("Ignoring unsupported Docker instruction: " + line);
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(br);
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly(br);
        Utils.closeQuietly(in);
        return result;
    }

    public static enum DockerCommandType {
        RUN,
        COPY,
        ADD;

    }

    public static class DockerCommand {
        DockerCommandType type;
        String argument;

        public static DockerCommand guess(String line) {
            DockerCommand result = null;
            for (DockerCommandType type : DockerCommandType.values()) {
                if (!line.startsWith(type.toString())) continue;
                result = new DockerCommand();
                result.type = type;
                result.argument = line.substring(type.toString().length()).trim();
                break;
            }
            return result;
        }

        public DockerCommandType getType() {
            return this.type;
        }

        public String getArgument() {
            return this.argument;
        }
    }
}

