/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.AbstractMap;
import java.util.Map;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.utils.Utils;

public final class IconUtils {
    public static final String MIME_JPG = "image/jpeg";
    public static final String MIME_PNG = "image/png";
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_BINARY = "application/octet-stream";

    private IconUtils() {
    }

    public static String encodeIconUrl(String name, String qualifier, File iconFile) {
        StringBuilder sb = new StringBuilder();
        if (iconFile != null) {
            sb.append("/");
            sb.append(name);
            if (!Utils.isEmptyOrWhitespaces(qualifier)) {
                sb.append("/" + qualifier);
            }
            sb.append("/");
            sb.append(iconFile.getName());
        }
        return sb.toString();
    }

    public static Map.Entry<String, String> decodeIconUrl(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String name = null;
        String qualifier = null;
        String[] parts = path.split("/");
        switch (parts.length) {
            case 2: {
                name = parts[0];
                break;
            }
            case 3: {
                name = parts[0];
                qualifier = parts[1];
                break;
            }
        }
        return new AbstractMap.SimpleEntry<String, Object>(name, qualifier);
    }

    public static File findIcon(AbstractApplication app) {
        return IconUtils.findIcon(app.getDirectory());
    }

    public static String findIconUrl(AbstractApplication app) {
        StringBuilder sb = new StringBuilder();
        File iconFile = IconUtils.findIcon(app);
        if (iconFile != null) {
            sb.append("/");
            sb.append(app.getName());
            if (app instanceof ApplicationTemplate) {
                sb.append("/");
                sb.append(((ApplicationTemplate)app).getQualifier());
            }
            sb.append("/");
            sb.append(iconFile.getName());
        }
        return sb.toString();
    }

    public static String findMimeType(File imgFile) {
        String name = imgFile.getName().toLowerCase();
        String result = name.endsWith(".jpg") || name.endsWith(".jpeg") ? MIME_JPG : (name.endsWith(".gif") ? MIME_GIF : (name.endsWith(".png") ? MIME_PNG : (name.endsWith(".svg") ? MIME_SVG : MIME_BINARY)));
        return result;
    }

    public static File findIcon(File rootDirectory) {
        File result = null;
        File[] imageFiles = new File(rootDirectory, "descriptor").listFiles(new ImgeFileFilter());
        if (imageFiles != null) {
            if (imageFiles.length == 1) {
                result = imageFiles[0];
            } else {
                for (File f : imageFiles) {
                    if (!f.getName().toLowerCase().startsWith("application.")) continue;
                    result = f;
                }
            }
        }
        return result;
    }

    private static class ImgeFileFilter
    implements FileFilter {
        private ImgeFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isFile() && f.getName().matches("(?i:.*\\.(png|gif|svg|jpg|jpeg)$)");
        }
    }
}

