/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.utils.Utils;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static Map<String, byte[]> storeInstanceResources(File applicationFilesDirectory, Instance instance) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        File instanceResourcesDirectory = ResourceUtils.findInstanceResourcesDirectory(applicationFilesDirectory, instance);
        if (instanceResourcesDirectory.exists() && instanceResourcesDirectory.isDirectory()) {
            result.putAll(Utils.storeDirectoryResourcesAsBytes(instanceResourcesDirectory));
        }
        result.putAll(ResourceUtils.storeInstanceProbeResources(applicationFilesDirectory, instance));
        return result;
    }

    public static Map<String, byte[]> storeInstanceProbeResources(File applicationFilesDirectory, Instance instance) throws IOException {
        String[] exts = new String[]{".measures", ".measures.properties"};
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (String ext : exts) {
            String fileName = instance.getComponent().getName() + ext;
            File autonomicMeasureFile = new File(applicationFilesDirectory, "probes/" + fileName);
            if (!autonomicMeasureFile.exists()) break;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStream(autonomicMeasureFile, os);
            result.put(autonomicMeasureFile.getName(), os.toByteArray());
        }
        return result;
    }

    public static File findInstanceResourcesDirectory(File applicationFilesDirectory, Instance instance) {
        return ResourceUtils.findInstanceResourcesDirectory(applicationFilesDirectory, instance.getComponent());
    }

    public static File findInstanceResourcesDirectory(File applicationFilesDirectory, Component component) {
        File root = new File(applicationFilesDirectory, "graph");
        File result = new File("No recipe directory.");
        HashSet<Component> alreadyChecked = new HashSet<Component>();
        for (Component c = component; c != null && !alreadyChecked.contains(c); c = c.getExtendedComponent()) {
            alreadyChecked.add(c);
            result = new File(root, c.getName());
            if (result.exists()) break;
        }
        return result;
    }

    public static Map<Component, File> findScopedInstancesDirectories(AbstractApplication absApp) {
        HashMap<Component, File> result = new HashMap<Component, File>();
        for (Component c : ComponentHelpers.findAllComponents(absApp.getGraphs())) {
            File dir;
            if (!ComponentHelpers.isTarget(c) || !(dir = ResourceUtils.findInstanceResourcesDirectory(absApp.getDirectory(), c)).exists()) continue;
            result.put(c, dir);
        }
        return result;
    }
}

