/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.roboconf.agent.AgentMessagingInterface;
import net.roboconf.agent.internal.AgentMessageProcessor;
import net.roboconf.agent.internal.AgentProperties;
import net.roboconf.agent.internal.misc.AgentUtils;
import net.roboconf.agent.internal.misc.HeartbeatTask;
import net.roboconf.agent.internal.misc.PluginMock;
import net.roboconf.agent.internal.misc.UserDataUtils;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.runtime.IReconfigurable;
import net.roboconf.core.utils.ProcessStore;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IAgentClient;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifMachineDown;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClientAgent;
import net.roboconf.plugin.api.PluginInterface;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Agent
implements AgentMessagingInterface,
IReconfigurable,
Pojo {
    InstanceManager __IM;
    private boolean __FapplicationName;
    String applicationName;
    private boolean __FscopedInstancePath;
    String scopedInstancePath;
    private boolean __FipAddress;
    String ipAddress;
    private boolean __FtargetId;
    String targetId;
    private boolean __FmessagingType;
    String messagingType;
    private boolean __Fdomain;
    String domain;
    private boolean __FnetworkInterface;
    String networkInterface;
    private boolean __FoverrideProperties;
    boolean overrideProperties;
    private boolean __FsimulatePlugins;
    boolean simulatePlugins;
    private boolean __Fplugins;
    final List<PluginInterface> plugins;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FmessagingClient;
    private ReconfigurableClientAgent messagingClient;
    private boolean __FscopedInstance;
    private Instance scopedInstance;
    private boolean __FheartBeatTimer;
    Timer heartBeatTimer;
    private boolean __FkarafEtc;
    String karafEtc;
    private boolean __FkarafData;
    String karafData;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MforceHeartbeatSending;
    boolean __MneedsModel;
    boolean __MgetMessagingClient;
    boolean __MfindPlugin$net_roboconf_core_model_beans_Instance;
    boolean __MlistPlugins;
    boolean __MpluginAppears$net_roboconf_plugin_api_PluginInterface;
    boolean __MpluginDisappears$net_roboconf_plugin_api_PluginInterface;
    boolean __MpluginWasModified$net_roboconf_plugin_api_PluginInterface;
    boolean __Mreconfigure;
    boolean __MgetApplicationName;
    boolean __MgetScopedInstancePath;
    boolean __MgetIpAddress;
    boolean __MgetMessagingType;
    boolean __MsetApplicationName$java_lang_String;
    boolean __MsetScopedInstancePath$java_lang_String;
    boolean __MsetIpAddress$java_lang_String;
    boolean __MsetTargetId$java_lang_String;
    boolean __MsetOverrideProperties$boolean;
    boolean __MsetSimulatePlugins$boolean;
    boolean __MsetNetworkInterface$java_lang_String;
    boolean __MsetDomain$java_lang_String;
    boolean __MgetDomain;
    boolean __MsetMessagingType$java_lang_String;
    boolean __MgetAgentId;
    boolean __MgetScopedInstance;
    boolean __MsetScopedInstance$net_roboconf_core_model_beans_Instance;
    boolean __MgetPlugins;
    boolean __MagentStatus;

    String __getapplicationName() {
        if (!this.__FapplicationName) {
            return this.applicationName;
        }
        return (String)this.__IM.onGet((Object)this, "applicationName");
    }

    void __setapplicationName(String string) {
        if (!this.__FapplicationName) {
            this.applicationName = string;
            return;
        }
        this.__IM.onSet((Object)this, "applicationName", (Object)string);
    }

    String __getscopedInstancePath() {
        if (!this.__FscopedInstancePath) {
            return this.scopedInstancePath;
        }
        return (String)this.__IM.onGet((Object)this, "scopedInstancePath");
    }

    void __setscopedInstancePath(String string) {
        if (!this.__FscopedInstancePath) {
            this.scopedInstancePath = string;
            return;
        }
        this.__IM.onSet((Object)this, "scopedInstancePath", (Object)string);
    }

    String __getipAddress() {
        if (!this.__FipAddress) {
            return this.ipAddress;
        }
        return (String)this.__IM.onGet((Object)this, "ipAddress");
    }

    void __setipAddress(String string) {
        if (!this.__FipAddress) {
            this.ipAddress = string;
            return;
        }
        this.__IM.onSet((Object)this, "ipAddress", (Object)string);
    }

    String __gettargetId() {
        if (!this.__FtargetId) {
            return this.targetId;
        }
        return (String)this.__IM.onGet((Object)this, "targetId");
    }

    void __settargetId(String string) {
        if (!this.__FtargetId) {
            this.targetId = string;
            return;
        }
        this.__IM.onSet((Object)this, "targetId", (Object)string);
    }

    String __getmessagingType() {
        if (!this.__FmessagingType) {
            return this.messagingType;
        }
        return (String)this.__IM.onGet((Object)this, "messagingType");
    }

    void __setmessagingType(String string) {
        if (!this.__FmessagingType) {
            this.messagingType = string;
            return;
        }
        this.__IM.onSet((Object)this, "messagingType", (Object)string);
    }

    String __getdomain() {
        if (!this.__Fdomain) {
            return this.domain;
        }
        return (String)this.__IM.onGet((Object)this, "domain");
    }

    void __setdomain(String string) {
        if (!this.__Fdomain) {
            this.domain = string;
            return;
        }
        this.__IM.onSet((Object)this, "domain", (Object)string);
    }

    String __getnetworkInterface() {
        if (!this.__FnetworkInterface) {
            return this.networkInterface;
        }
        return (String)this.__IM.onGet((Object)this, "networkInterface");
    }

    void __setnetworkInterface(String string) {
        if (!this.__FnetworkInterface) {
            this.networkInterface = string;
            return;
        }
        this.__IM.onSet((Object)this, "networkInterface", (Object)string);
    }

    boolean __getoverrideProperties() {
        if (!this.__FoverrideProperties) {
            return this.overrideProperties;
        }
        Object object = this.__IM.onGet((Object)this, "overrideProperties");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setoverrideProperties(boolean bl) {
        if (!this.__FoverrideProperties) {
            this.overrideProperties = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "overrideProperties", (Object)bl2);
    }

    boolean __getsimulatePlugins() {
        if (!this.__FsimulatePlugins) {
            return this.simulatePlugins;
        }
        Object object = this.__IM.onGet((Object)this, "simulatePlugins");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setsimulatePlugins(boolean bl) {
        if (!this.__FsimulatePlugins) {
            this.simulatePlugins = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "simulatePlugins", (Object)bl2);
    }

    List __getplugins() {
        if (!this.__Fplugins) {
            return this.plugins;
        }
        return (List)this.__IM.onGet((Object)this, "plugins");
    }

    void __setplugins(List list) {
        if (!this.__Fplugins) {
            this.plugins = list;
            return;
        }
        this.__IM.onSet((Object)this, "plugins", (Object)list);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    ReconfigurableClientAgent __getmessagingClient() {
        if (!this.__FmessagingClient) {
            return this.messagingClient;
        }
        return (ReconfigurableClientAgent)this.__IM.onGet((Object)this, "messagingClient");
    }

    void __setmessagingClient(ReconfigurableClientAgent reconfigurableClientAgent) {
        if (!this.__FmessagingClient) {
            this.messagingClient = reconfigurableClientAgent;
            return;
        }
        this.__IM.onSet((Object)this, "messagingClient", (Object)reconfigurableClientAgent);
    }

    Instance __getscopedInstance() {
        if (!this.__FscopedInstance) {
            return this.scopedInstance;
        }
        return (Instance)this.__IM.onGet((Object)this, "scopedInstance");
    }

    void __setscopedInstance(Instance instance) {
        if (!this.__FscopedInstance) {
            this.scopedInstance = instance;
            return;
        }
        this.__IM.onSet((Object)this, "scopedInstance", (Object)instance);
    }

    Timer __getheartBeatTimer() {
        if (!this.__FheartBeatTimer) {
            return this.heartBeatTimer;
        }
        return (Timer)this.__IM.onGet((Object)this, "heartBeatTimer");
    }

    void __setheartBeatTimer(Timer timer) {
        if (!this.__FheartBeatTimer) {
            this.heartBeatTimer = timer;
            return;
        }
        this.__IM.onSet((Object)this, "heartBeatTimer", (Object)timer);
    }

    String __getkarafEtc() {
        if (!this.__FkarafEtc) {
            return this.karafEtc;
        }
        return (String)this.__IM.onGet((Object)this, "karafEtc");
    }

    void __setkarafEtc(String string) {
        if (!this.__FkarafEtc) {
            this.karafEtc = string;
            return;
        }
        this.__IM.onSet((Object)this, "karafEtc", (Object)string);
    }

    String __getkarafData() {
        if (!this.__FkarafData) {
            return this.karafData;
        }
        return (String)this.__IM.onGet((Object)this, "karafData");
    }

    void __setkarafData(String string) {
        if (!this.__FkarafData) {
            this.karafData = string;
            return;
        }
        this.__IM.onSet((Object)this, "karafData", (Object)string);
    }

    public Agent() {
        this(null);
    }

    private Agent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdomain("default");
        this.__setnetworkInterface("rbcf-default-network");
        this.__setoverrideProperties(false);
        this.__setsimulatePlugins(true);
        this.__setplugins(new ArrayList());
        this.__setkarafEtc(System.getProperty("karaf.etc"));
        this.__setkarafData(System.getProperty("karaf.data"));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        this.__getlogger().info("Agent '" + this.getAgentId() + "' is about to be launched.");
        this.__setipAddress(AgentUtils.findIpAddress(this.__getnetworkInterface()));
        this.__getlogger().info("IP address resolved to " + this.__getipAddress());
        this.__setmessagingClient(new ReconfigurableClientAgent());
        this.__getmessagingClient().setDomain(this.__getdomain());
        AgentMessageProcessor messageProcessor = new AgentMessageProcessor(this);
        this.__getmessagingClient().associateMessageProcessor((AbstractMessageProcessor)messageProcessor);
        if (Utils.isEmptyOrWhitespaces((String)this.__gettargetId())) {
            this.__getlogger().warning("No target ID was specified in the agent configuration. No user data will be retrieved.");
        } else if (!this.__getoverrideProperties()) {
            this.__getlogger().fine("User data are NOT supposed to be used.");
        } else {
            AgentProperties props = null;
            this.__getlogger().fine("User data are supposed to be used. Retrieving in progress...");
            if ("iaas-ec2".equalsIgnoreCase(this.__gettargetId()) || "iaas-openstack".equalsIgnoreCase(this.__gettargetId())) {
                props = UserDataUtils.findParametersForAmazonOrOpenStack(this.__getlogger());
            } else if ("iaas-azure".equalsIgnoreCase(this.__gettargetId())) {
                props = UserDataUtils.findParametersForAzure(this.__getlogger());
            } else if ("iaas-vmware".equalsIgnoreCase(this.__gettargetId())) {
                props = UserDataUtils.findParametersForVmware(this.__getlogger());
            } else {
                this.__getlogger().warning("Unknown target ID. No user data will be retrieved.");
            }
            if (props != null) {
                String errorMessage = props.validate();
                if (errorMessage != null) {
                    this.__getlogger().severe("An error was found in user data. " + errorMessage);
                }
                this.__setapplicationName(props.getApplicationName());
                this.__setscopedInstancePath(props.getScopedInstancePath());
                if (!Utils.isEmptyOrWhitespaces((String)props.getIpAddress())) {
                    this.__setipAddress(props.getIpAddress());
                    this.__getlogger().info("The agent's address was overwritten from user data and set to " + this.__getipAddress());
                }
                try {
                    this.__getlogger().info("Reconfiguring the agent with user data.");
                    UserDataUtils.reconfigureMessaging(this.__getkarafEtc(), props.getMessagingConfiguration());
                }
                catch (IOException e) {
                    this.__getlogger().severe("Error in messaging reconfiguration from user data: " + e);
                }
            }
        }
        this.reconfigure();
        HeartbeatTask timerTask = new HeartbeatTask(this);
        this.__setheartBeatTimer(new Timer("Roboconf's Heartbeat Timer @ Agent", true));
        this.__getheartBeatTimer().scheduleAtFixedRate((TimerTask)timerTask, 60000L, 60000L);
        this.__getlogger().info("Agent '" + this.getAgentId() + "' was launched.");
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__getlogger().info("Agent '" + this.getAgentId() + "' is about to be stopped.");
        if (this.__getheartBeatTimer() != null) {
            this.__getheartBeatTimer().cancel();
            this.__setheartBeatTimer(null);
        }
        if (this.__getmessagingClient() == null) {
            return;
        }
        try {
            if (this.__getmessagingClient().isConnected()) {
                this.__getmessagingClient().sendMessageToTheDm((Message)new MsgNotifMachineDown(this.__getapplicationName(), this.__getscopedInstancePath()));
                this.__getlogger().fine("Agent " + this.getAgentId() + " notified the DM it was about to stop.");
            }
        }
        catch (IOException e) {
            this.__getlogger().warning(e.getMessage());
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
        try {
            this.__getmessagingClient().getMessageProcessor().stopProcessor();
            this.__getmessagingClient().getMessageProcessor().interrupt();
            this.__getmessagingClient().closeConnection();
        }
        catch (IOException e) {
            this.__getlogger().warning(e.getMessage());
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
        this.__getlogger().info("Agent '" + this.getAgentId() + "' was stopped.");
    }

    @Override
    public void forceHeartbeatSending() {
        if (!this.__MforceHeartbeatSending) {
            this.__M_forceHeartbeatSending();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "forceHeartbeatSending", new Object[0]);
            this.__M_forceHeartbeatSending();
            this.__IM.onExit((Object)this, "forceHeartbeatSending", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "forceHeartbeatSending", throwable);
            throw throwable;
        }
    }

    private void __M_forceHeartbeatSending() {
        new HeartbeatTask(this).run();
    }

    public boolean needsModel() {
        boolean bl;
        if (!this.__MneedsModel) {
            return this.__M_needsModel();
        }
        try {
            this.__IM.onEntry((Object)this, "needsModel", new Object[0]);
            bl = this.__M_needsModel();
            this.__IM.onExit((Object)this, "needsModel", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "needsModel", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_needsModel() {
        AgentMessageProcessor messageProcessor = null;
        if (this.__getmessagingClient() != null) {
            messageProcessor = (AgentMessageProcessor)this.__getmessagingClient().getMessageProcessor();
        }
        return messageProcessor == null || messageProcessor.scopedInstance == null;
    }

    public ReconfigurableClientAgent getMessagingClient() {
        ReconfigurableClientAgent reconfigurableClientAgent;
        if (!this.__MgetMessagingClient) {
            return this.__M_getMessagingClient();
        }
        try {
            this.__IM.onEntry((Object)this, "getMessagingClient", new Object[0]);
            reconfigurableClientAgent = this.__M_getMessagingClient();
            this.__IM.onExit((Object)this, "getMessagingClient", (Object)reconfigurableClientAgent);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessagingClient", throwable);
            throw throwable;
        }
        return reconfigurableClientAgent;
    }

    private ReconfigurableClientAgent __M_getMessagingClient() {
        return this.__getmessagingClient();
    }

    public PluginInterface findPlugin(Instance instance) {
        PluginInterface pluginInterface;
        if (!this.__MfindPlugin$net_roboconf_core_model_beans_Instance) {
            return this.__M_findPlugin(instance);
        }
        try {
            this.__IM.onEntry((Object)this, "findPlugin$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            pluginInterface = this.__M_findPlugin(instance);
            this.__IM.onExit((Object)this, "findPlugin$net_roboconf_core_model_beans_Instance", (Object)pluginInterface);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findPlugin$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return pluginInterface;
    }

    private PluginInterface __M_findPlugin(Instance instance) {
        PluginMock result = null;
        if (this.__getsimulatePlugins()) {
            result = new PluginMock();
        } else {
            String installerName = null;
            if (instance.getComponent() != null) {
                installerName = ComponentHelpers.findComponentInstaller((Component)instance.getComponent());
            }
            for (PluginInterface pi : this.__getplugins()) {
                if (!pi.getPluginName().equalsIgnoreCase(installerName)) continue;
                result = pi;
                break;
            }
            if (result == null) {
                this.__getlogger().severe("No plugin was found for instance '" + instance.getName() + "' with installer '" + installerName + "'.");
            }
        }
        if (result != null) {
            result.setNames(this.__getapplicationName(), this.__getscopedInstancePath());
        }
        return result;
    }

    public void listPlugins() {
        if (!this.__MlistPlugins) {
            this.__M_listPlugins();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "listPlugins", new Object[0]);
            this.__M_listPlugins();
            this.__IM.onExit((Object)this, "listPlugins", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listPlugins", throwable);
            throw throwable;
        }
    }

    private void __M_listPlugins() {
        if (this.__getplugins().isEmpty()) {
            this.__getlogger().info("No plug-in was found for Roboconf's agent.");
        } else {
            StringBuilder sb = new StringBuilder("Available plug-ins in Roboconf's agent: ");
            Iterator it = this.__getplugins().iterator();
            while (it.hasNext()) {
                sb.append(((PluginInterface)it.next()).getPluginName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(".");
            this.__getlogger().info(sb.toString());
        }
    }

    public void pluginAppears(PluginInterface pi) {
        if (!this.__MpluginAppears$net_roboconf_plugin_api_PluginInterface) {
            this.__M_pluginAppears(pi);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "pluginAppears$net_roboconf_plugin_api_PluginInterface", new Object[]{pi});
            this.__M_pluginAppears(pi);
            this.__IM.onExit((Object)this, "pluginAppears$net_roboconf_plugin_api_PluginInterface", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "pluginAppears$net_roboconf_plugin_api_PluginInterface", throwable);
            throw throwable;
        }
    }

    private void __M_pluginAppears(PluginInterface pi) {
        if (pi != null) {
            this.__getlogger().info("Plugin '" + pi.getPluginName() + "' is now available in Roboconf's agent.");
            this.__getplugins().add(pi);
            this.listPlugins();
        }
    }

    public void pluginDisappears(PluginInterface pi) {
        if (!this.__MpluginDisappears$net_roboconf_plugin_api_PluginInterface) {
            this.__M_pluginDisappears(pi);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "pluginDisappears$net_roboconf_plugin_api_PluginInterface", new Object[]{pi});
            this.__M_pluginDisappears(pi);
            this.__IM.onExit((Object)this, "pluginDisappears$net_roboconf_plugin_api_PluginInterface", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "pluginDisappears$net_roboconf_plugin_api_PluginInterface", throwable);
            throw throwable;
        }
    }

    private void __M_pluginDisappears(PluginInterface pi) {
        if (pi == null) {
            this.__getlogger().info("An invalid plugin is removed.");
        } else {
            this.__getplugins().remove(pi);
            this.__getlogger().info("Plugin '" + pi.getPluginName() + "' is not available anymore in Roboconf's agent.");
        }
        this.listPlugins();
    }

    public void pluginWasModified(PluginInterface pi) {
        if (!this.__MpluginWasModified$net_roboconf_plugin_api_PluginInterface) {
            this.__M_pluginWasModified(pi);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "pluginWasModified$net_roboconf_plugin_api_PluginInterface", new Object[]{pi});
            this.__M_pluginWasModified(pi);
            this.__IM.onExit((Object)this, "pluginWasModified$net_roboconf_plugin_api_PluginInterface", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "pluginWasModified$net_roboconf_plugin_api_PluginInterface", throwable);
            throw throwable;
        }
    }

    private void __M_pluginWasModified(PluginInterface pi) {
        this.__getlogger().info("Plugin '" + pi.getPluginName() + "' was modified in Roboconf's agent.");
        this.listPlugins();
    }

    public void reconfigure() {
        if (!this.__Mreconfigure) {
            this.__M_reconfigure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconfigure", new Object[0]);
            this.__M_reconfigure();
            this.__IM.onExit((Object)this, "reconfigure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconfigure", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure() {
        this.__getlogger().info("Reconfiguration requested in agent " + this.getAgentId());
        if (this.__getmessagingClient() == null) {
            this.__getlogger().info("The agent has not yet been started. Configuration is dropped.");
            return;
        }
        this.__getmessagingClient().setApplicationName(this.__getapplicationName());
        this.__getmessagingClient().setScopedInstancePath(this.__getscopedInstancePath());
        this.__getmessagingClient().setIpAddress(this.__getipAddress());
        this.__getmessagingClient().setNeedsModel(this.needsModel());
        this.__getmessagingClient().setDomain(this.__getdomain());
        this.__getmessagingClient().switchMessagingType(this.__getmessagingType());
        AgentUtils.injectConfigurations(this.__getkarafEtc(), this.__getapplicationName(), this.__getscopedInstancePath(), this.__getdomain(), this.__getipAddress());
        this.__getlogger().info("The agent was successfully (re)configured.");
    }

    @Override
    public String getApplicationName() {
        String string;
        if (!this.__MgetApplicationName) {
            return this.__M_getApplicationName();
        }
        try {
            this.__IM.onEntry((Object)this, "getApplicationName", new Object[0]);
            string = this.__M_getApplicationName();
            this.__IM.onExit((Object)this, "getApplicationName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getApplicationName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getApplicationName() {
        return this.__getapplicationName();
    }

    @Override
    public String getScopedInstancePath() {
        String string;
        if (!this.__MgetScopedInstancePath) {
            return this.__M_getScopedInstancePath();
        }
        try {
            this.__IM.onEntry((Object)this, "getScopedInstancePath", new Object[0]);
            string = this.__M_getScopedInstancePath();
            this.__IM.onExit((Object)this, "getScopedInstancePath", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScopedInstancePath", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getScopedInstancePath() {
        return this.__getscopedInstancePath();
    }

    public String getIpAddress() {
        String string;
        if (!this.__MgetIpAddress) {
            return this.__M_getIpAddress();
        }
        try {
            this.__IM.onEntry((Object)this, "getIpAddress", new Object[0]);
            string = this.__M_getIpAddress();
            this.__IM.onExit((Object)this, "getIpAddress", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIpAddress", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getIpAddress() {
        return this.__getipAddress();
    }

    public String getMessagingType() {
        String string;
        if (!this.__MgetMessagingType) {
            return this.__M_getMessagingType();
        }
        try {
            this.__IM.onEntry((Object)this, "getMessagingType", new Object[0]);
            string = this.__M_getMessagingType();
            this.__IM.onExit((Object)this, "getMessagingType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessagingType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getMessagingType() {
        return this.__getmessagingType();
    }

    public void setApplicationName(String applicationName) {
        if (!this.__MsetApplicationName$java_lang_String) {
            this.__M_setApplicationName(applicationName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setApplicationName$java_lang_String", new Object[]{applicationName});
            this.__M_setApplicationName(applicationName);
            this.__IM.onExit((Object)this, "setApplicationName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setApplicationName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setApplicationName(String applicationName) {
        this.__setapplicationName(applicationName);
    }

    public void setScopedInstancePath(String scopedInstancePath) {
        if (!this.__MsetScopedInstancePath$java_lang_String) {
            this.__M_setScopedInstancePath(scopedInstancePath);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setScopedInstancePath$java_lang_String", new Object[]{scopedInstancePath});
            this.__M_setScopedInstancePath(scopedInstancePath);
            this.__IM.onExit((Object)this, "setScopedInstancePath$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setScopedInstancePath$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setScopedInstancePath(String scopedInstancePath) {
        this.__setscopedInstancePath(scopedInstancePath);
    }

    public void setIpAddress(String ipAddress) {
        if (!this.__MsetIpAddress$java_lang_String) {
            this.__M_setIpAddress(ipAddress);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setIpAddress$java_lang_String", new Object[]{ipAddress});
            this.__M_setIpAddress(ipAddress);
            this.__IM.onExit((Object)this, "setIpAddress$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setIpAddress$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setIpAddress(String ipAddress) {
        if (!Utils.isEmptyOrWhitespaces((String)ipAddress)) {
            this.__setipAddress(ipAddress);
            this.__getlogger().finer("New IP address set in the agent: " + ipAddress);
        }
    }

    public void setTargetId(String targetId) {
        if (!this.__MsetTargetId$java_lang_String) {
            this.__M_setTargetId(targetId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTargetId$java_lang_String", new Object[]{targetId});
            this.__M_setTargetId(targetId);
            this.__IM.onExit((Object)this, "setTargetId$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTargetId$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setTargetId(String targetId) {
        this.__settargetId(targetId);
    }

    public void setOverrideProperties(boolean overrideProperties) {
        if (!this.__MsetOverrideProperties$boolean) {
            this.__M_setOverrideProperties(overrideProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOverrideProperties$boolean", new Object[]{new Boolean(overrideProperties)});
            this.__M_setOverrideProperties(overrideProperties);
            this.__IM.onExit((Object)this, "setOverrideProperties$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOverrideProperties$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setOverrideProperties(boolean overrideProperties) {
        this.__setoverrideProperties(overrideProperties);
    }

    public void setSimulatePlugins(boolean simulatePlugins) {
        if (!this.__MsetSimulatePlugins$boolean) {
            this.__M_setSimulatePlugins(simulatePlugins);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setSimulatePlugins$boolean", new Object[]{new Boolean(simulatePlugins)});
            this.__M_setSimulatePlugins(simulatePlugins);
            this.__IM.onExit((Object)this, "setSimulatePlugins$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setSimulatePlugins$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setSimulatePlugins(boolean simulatePlugins) {
        this.__setsimulatePlugins(simulatePlugins);
    }

    public void setNetworkInterface(String networkInterface) {
        if (!this.__MsetNetworkInterface$java_lang_String) {
            this.__M_setNetworkInterface(networkInterface);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNetworkInterface$java_lang_String", new Object[]{networkInterface});
            this.__M_setNetworkInterface(networkInterface);
            this.__IM.onExit((Object)this, "setNetworkInterface$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNetworkInterface$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setNetworkInterface(String networkInterface) {
        this.__setnetworkInterface(networkInterface);
        this.__getlogger().info("New network interface set: " + networkInterface);
        if (!this.__getoverrideProperties()) {
            this.__getlogger().info("Resetting the agent's IP address...");
            this.__setipAddress(AgentUtils.findIpAddress(networkInterface));
            this.__getlogger().info("New IP address: " + this.__getipAddress());
        } else {
            this.__getlogger().info("User data are used. The IP address will not be refreshed.");
        }
    }

    public void setDomain(String domain) {
        if (!this.__MsetDomain$java_lang_String) {
            this.__M_setDomain(domain);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDomain$java_lang_String", new Object[]{domain});
            this.__M_setDomain(domain);
            this.__IM.onExit((Object)this, "setDomain$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDomain$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setDomain(String domain) {
        this.__setdomain(domain);
    }

    @Override
    public String getDomain() {
        String string;
        if (!this.__MgetDomain) {
            return this.__M_getDomain();
        }
        try {
            this.__IM.onEntry((Object)this, "getDomain", new Object[0]);
            string = this.__M_getDomain();
            this.__IM.onExit((Object)this, "getDomain", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDomain", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDomain() {
        return this.__getdomain();
    }

    public void setMessagingType(String messagingType) {
        if (!this.__MsetMessagingType$java_lang_String) {
            this.__M_setMessagingType(messagingType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMessagingType$java_lang_String", new Object[]{messagingType});
            this.__M_setMessagingType(messagingType);
            this.__IM.onExit((Object)this, "setMessagingType$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMessagingType$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setMessagingType(String messagingType) {
        this.__setmessagingType(messagingType);
    }

    String getAgentId() {
        String string;
        if (!this.__MgetAgentId) {
            return this.__M_getAgentId();
        }
        try {
            this.__IM.onEntry((Object)this, "getAgentId", new Object[0]);
            string = this.__M_getAgentId();
            this.__IM.onExit((Object)this, "getAgentId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAgentId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getAgentId() {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.isEmptyOrWhitespaces((String)this.__getscopedInstancePath()) ? "?" : this.__getscopedInstancePath());
        if (!Utils.isEmptyOrWhitespaces((String)this.__getapplicationName())) {
            sb.append(" @ ").append(this.__getapplicationName());
        }
        return sb.toString();
    }

    @Override
    public Instance getScopedInstance() {
        Instance instance;
        if (!this.__MgetScopedInstance) {
            return this.__M_getScopedInstance();
        }
        try {
            this.__IM.onEntry((Object)this, "getScopedInstance", new Object[0]);
            instance = this.__M_getScopedInstance();
            this.__IM.onExit((Object)this, "getScopedInstance", (Object)instance);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScopedInstance", throwable);
            throw throwable;
        }
        return instance;
    }

    private Instance __M_getScopedInstance() {
        return this.__getscopedInstance();
    }

    public void setScopedInstance(Instance scopedInstance) {
        if (!this.__MsetScopedInstance$net_roboconf_core_model_beans_Instance) {
            this.__M_setScopedInstance(scopedInstance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setScopedInstance$net_roboconf_core_model_beans_Instance", new Object[]{scopedInstance});
            this.__M_setScopedInstance(scopedInstance);
            this.__IM.onExit((Object)this, "setScopedInstance$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setScopedInstance$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_setScopedInstance(Instance scopedInstance) {
        this.__setscopedInstance(scopedInstance);
    }

    public List<PluginInterface> getPlugins() {
        List<PluginInterface> list;
        if (!this.__MgetPlugins) {
            return this.__M_getPlugins();
        }
        try {
            this.__IM.onEntry((Object)this, "getPlugins", new Object[0]);
            list = this.__M_getPlugins();
            this.__IM.onExit((Object)this, "getPlugins", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPlugins", throwable);
            throw throwable;
        }
        return list;
    }

    private List<PluginInterface> __M_getPlugins() {
        return this.__getplugins();
    }

    @Override
    public String agentStatus() {
        String string;
        if (!this.__MagentStatus) {
            return this.__M_agentStatus();
        }
        try {
            this.__IM.onEntry((Object)this, "agentStatus", new Object[0]);
            string = this.__M_agentStatus();
            this.__IM.onExit((Object)this, "agentStatus", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "agentStatus", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_agentStatus() {
        StringBuilder sb = new StringBuilder();
        LinkedBlockingQueue agentQueue = this.__getmessagingClient().getMessageProcessor().getMessageQueue();
        if (agentQueue.isEmpty()) {
            sb.append("There is no message being processed in agent queue\n");
        } else {
            sb.append("Agent " + this.getScopedInstancePath() + " (" + this.getApplicationName() + ")\n");
            sb.append("The number total of messages in agent queue is : " + agentQueue.size() + "\n");
            sb.append("The types of messages being processed are : \n");
            for (Message msg : agentQueue) {
                sb.append(msg.getClass().getSimpleName() + "\n");
            }
        }
        Process p = ProcessStore.getProcess((String)this.__getapplicationName(), (String)this.__getscopedInstancePath());
        if (p != null) {
            sb.append("Be careful. A recipe is under execution.");
        } else {
            sb.append("No recipe is under execution.");
        }
        return sb.toString();
    }

    private IAgentClient __M_getMessagingClient() {
        return this.getMessagingClient();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("applicationName")) {
                this.__FapplicationName = true;
            }
            if (set.contains("domain")) {
                this.__Fdomain = true;
            }
            if (set.contains("heartBeatTimer")) {
                this.__FheartBeatTimer = true;
            }
            if (set.contains("ipAddress")) {
                this.__FipAddress = true;
            }
            if (set.contains("karafData")) {
                this.__FkarafData = true;
            }
            if (set.contains("karafEtc")) {
                this.__FkarafEtc = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("messagingClient")) {
                this.__FmessagingClient = true;
            }
            if (set.contains("messagingType")) {
                this.__FmessagingType = true;
            }
            if (set.contains("networkInterface")) {
                this.__FnetworkInterface = true;
            }
            if (set.contains("overrideProperties")) {
                this.__FoverrideProperties = true;
            }
            if (set.contains("plugins")) {
                this.__Fplugins = true;
            }
            if (set.contains("scopedInstance")) {
                this.__FscopedInstance = true;
            }
            if (set.contains("scopedInstancePath")) {
                this.__FscopedInstancePath = true;
            }
            if (set.contains("simulatePlugins")) {
                this.__FsimulatePlugins = true;
            }
            if (set.contains("targetId")) {
                this.__FtargetId = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("forceHeartbeatSending")) {
                this.__MforceHeartbeatSending = true;
            }
            if (set.contains("needsModel")) {
                this.__MneedsModel = true;
            }
            if (set.contains("getMessagingClient")) {
                this.__MgetMessagingClient = true;
            }
            if (set.contains("findPlugin$net_roboconf_core_model_beans_Instance")) {
                this.__MfindPlugin$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("listPlugins")) {
                this.__MlistPlugins = true;
            }
            if (set.contains("pluginAppears$net_roboconf_plugin_api_PluginInterface")) {
                this.__MpluginAppears$net_roboconf_plugin_api_PluginInterface = true;
            }
            if (set.contains("pluginDisappears$net_roboconf_plugin_api_PluginInterface")) {
                this.__MpluginDisappears$net_roboconf_plugin_api_PluginInterface = true;
            }
            if (set.contains("pluginWasModified$net_roboconf_plugin_api_PluginInterface")) {
                this.__MpluginWasModified$net_roboconf_plugin_api_PluginInterface = true;
            }
            if (set.contains("reconfigure")) {
                this.__Mreconfigure = true;
            }
            if (set.contains("getApplicationName")) {
                this.__MgetApplicationName = true;
            }
            if (set.contains("getScopedInstancePath")) {
                this.__MgetScopedInstancePath = true;
            }
            if (set.contains("getIpAddress")) {
                this.__MgetIpAddress = true;
            }
            if (set.contains("getMessagingType")) {
                this.__MgetMessagingType = true;
            }
            if (set.contains("setApplicationName$java_lang_String")) {
                this.__MsetApplicationName$java_lang_String = true;
            }
            if (set.contains("setScopedInstancePath$java_lang_String")) {
                this.__MsetScopedInstancePath$java_lang_String = true;
            }
            if (set.contains("setIpAddress$java_lang_String")) {
                this.__MsetIpAddress$java_lang_String = true;
            }
            if (set.contains("setTargetId$java_lang_String")) {
                this.__MsetTargetId$java_lang_String = true;
            }
            if (set.contains("setOverrideProperties$boolean")) {
                this.__MsetOverrideProperties$boolean = true;
            }
            if (set.contains("setSimulatePlugins$boolean")) {
                this.__MsetSimulatePlugins$boolean = true;
            }
            if (set.contains("setNetworkInterface$java_lang_String")) {
                this.__MsetNetworkInterface$java_lang_String = true;
            }
            if (set.contains("setDomain$java_lang_String")) {
                this.__MsetDomain$java_lang_String = true;
            }
            if (set.contains("getDomain")) {
                this.__MgetDomain = true;
            }
            if (set.contains("setMessagingType$java_lang_String")) {
                this.__MsetMessagingType$java_lang_String = true;
            }
            if (set.contains("getAgentId")) {
                this.__MgetAgentId = true;
            }
            if (set.contains("getScopedInstance")) {
                this.__MgetScopedInstance = true;
            }
            if (set.contains("setScopedInstance$net_roboconf_core_model_beans_Instance")) {
                this.__MsetScopedInstance$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("getPlugins")) {
                this.__MgetPlugins = true;
            }
            if (set.contains("agentStatus")) {
                this.__MagentStatus = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

