/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.agent.internal.Agent;
import net.roboconf.agent.internal.lifecycle.AbstractLifeCycleManager;
import net.roboconf.agent.internal.misc.AgentUtils;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.ImportHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IAgentClient;
import net.roboconf.messaging.api.business.ListenerCommand;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdAddImport;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdRemoveImport;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdRequestImport;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceChanged;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceRemoved;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifLogs;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdAddInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeBinding;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeInstanceState;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeLogLevel;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdGatherLogs;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdRemoveInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdResynchronize;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdSendInstances;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdSetScopedInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdUpdateProbeConfiguration;
import net.roboconf.messaging.api.messages.from_dm_to_dm.MsgEcho;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;

public class AgentMessageProcessor
extends AbstractMessageProcessor<IAgentClient> {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final Agent agent;
    Instance scopedInstance;
    final Map<String, Set<String>> applicationBindings = new HashMap<String, Set<String>>();
    final Map<String, Collection<Import>> applicationNameToExternalExports = new HashMap<String, Collection<Import>>();

    public AgentMessageProcessor(Agent agent) {
        super("Roboconf Agent - Message Processor");
        this.agent = agent;
    }

    protected void processMessage(Message message) {
        this.logger.fine("A message of type " + message.getClass().getSimpleName() + " was received and is about to be processed.");
        try {
            if (message instanceof MsgCmdSetScopedInstance) {
                this.processMsgSetScopedInstance((MsgCmdSetScopedInstance)message);
            } else if (message instanceof MsgCmdRemoveInstance) {
                this.processMsgRemoveInstance((MsgCmdRemoveInstance)message);
            } else if (message instanceof MsgCmdAddInstance) {
                this.processMsgAddInstance((MsgCmdAddInstance)message);
            } else if (message instanceof MsgCmdChangeInstanceState) {
                this.processMsgChangeInstanceState((MsgCmdChangeInstanceState)message);
            } else if (message instanceof MsgCmdAddImport) {
                this.processMsgAddImport((MsgCmdAddImport)message);
            } else if (message instanceof MsgCmdRemoveImport) {
                this.processMsgRemoveImport((MsgCmdRemoveImport)message, true);
            } else if (message instanceof MsgCmdRequestImport) {
                this.processMsgRequestImport((MsgCmdRequestImport)message);
            } else if (message instanceof MsgCmdSendInstances) {
                this.processMsgSendInstances((MsgCmdSendInstances)message);
            } else if (message instanceof MsgCmdResynchronize) {
                this.processMsgResynchronize((MsgCmdResynchronize)message);
            } else if (message instanceof MsgEcho) {
                this.processMsgEcho((MsgEcho)message);
            } else if (message instanceof MsgCmdChangeBinding) {
                this.processMsgChangeBinding((MsgCmdChangeBinding)message);
            } else if (message instanceof MsgCmdUpdateProbeConfiguration) {
                this.processUpdateProbeConfiguration((MsgCmdUpdateProbeConfiguration)message);
            } else if (message instanceof MsgCmdChangeLogLevel) {
                this.processChangeLogLevel((MsgCmdChangeLogLevel)message);
            } else if (message instanceof MsgCmdGatherLogs) {
                this.processGatherLogs((MsgCmdGatherLogs)message);
            } else {
                this.logger.warning(this.getName() + " got an undetermined message to process. " + message.getClass().getName());
            }
        }
        catch (IOException e) {
            this.logger.severe("A problem occurred with the messaging. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        catch (PluginException e) {
            this.logger.severe("A problem occurred with a plug-in. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    private void processGatherLogs(MsgCmdGatherLogs message) throws IOException {
        Map<String, byte[]> logFiles = AgentUtils.collectLogs(this.agent.karafData);
        MsgNotifLogs msg = new MsgNotifLogs(this.agent.getApplicationName(), this.agent.getScopedInstancePath(), logFiles);
        ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)msg);
    }

    private void processChangeLogLevel(MsgCmdChangeLogLevel message) throws IOException {
        AgentUtils.changeRoboconfLogLevel(message.getLogLevel(), this.agent.karafEtc);
    }

    private void processUpdateProbeConfiguration(MsgCmdUpdateProbeConfiguration message) throws IOException {
        Instance inst = InstanceHelpers.findInstanceByPath((Instance)this.scopedInstance, (String)message.getInstancePath());
        if (inst == null) {
            this.logger.warning("Instance " + message.getInstancePath() + " could not be found. Probe configuration will not be updated.");
        } else {
            AgentUtils.copyInstanceResources(inst, message.getProbeResources());
        }
    }

    void processMsgChangeBinding(MsgCmdChangeBinding msg) throws IOException {
        MsgCmdRemoveImport fakeMsg;
        HashSet newBindings;
        this.logger.fine("Updating bound applications for prefix " + msg.getExternalExportsPrefix() + ".");
        Set<String> oldBindings = this.applicationBindings.get(msg.getExternalExportsPrefix());
        if (oldBindings == null) {
            oldBindings = new HashSet<String>(0);
        }
        if ((newBindings = msg.getAppNames()) == null) {
            newBindings = new HashSet(0);
        }
        LinkedHashSet<String> removedAppNames = new LinkedHashSet<String>(oldBindings);
        removedAppNames.removeAll(newBindings);
        LinkedHashSet addedAppNames = new LinkedHashSet(newBindings);
        addedAppNames.removeAll(oldBindings);
        for (String removedAppName : removedAppNames) {
            this.logger.fine("Unbiding prefix " + msg.getExternalExportsPrefix() + " from application " + removedAppName + ".");
            ArrayList<String> instancePaths = new ArrayList<String>();
            for (Instance instance : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
                Collection imports = (Collection)instance.getImports().get(msg.getExternalExportsPrefix());
                if (imports == null) continue;
                for (Import imp : imports) {
                    instancePaths.add(imp.getInstancePath());
                }
            }
            for (String path : instancePaths) {
                fakeMsg = new MsgCmdRemoveImport(removedAppName, msg.getExternalExportsPrefix(), path);
                try {
                    this.processMsgRemoveImport(fakeMsg, false);
                }
                catch (PluginException e) {
                    this.logger.severe("A problem occurred with a plug-in. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
        this.applicationBindings.put(msg.getExternalExportsPrefix(), msg.getAppNames());
        for (String addedAppName : addedAppNames) {
            this.logger.fine("Binding prefix " + msg.getExternalExportsPrefix() + " with application " + addedAppName + ".");
            Collection<Import> imports = this.applicationNameToExternalExports.get(addedAppName);
            if (imports == null) continue;
            for (Import imp : imports) {
                fakeMsg = new MsgCmdAddImport(addedAppName, imp.getComponentName(), imp.getInstancePath(), imp.getExportedVars());
                try {
                    this.processMsgAddImport((MsgCmdAddImport)fakeMsg);
                }
                catch (PluginException e) {
                    this.logger.severe("A problem occurred with a plug-in. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
    }

    void processMsgEcho(MsgEcho message) throws IOException {
        String content = message.getContent();
        MsgEcho response = new MsgEcho(content.replaceFirst("^PING:", "PONG:"), message.getUuid());
        this.logger.fine("Responding to DM Echo message " + content + " with response " + response.getContent());
        ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)response);
    }

    void processMsgResynchronize(MsgCmdResynchronize message) throws IOException {
        if (this.scopedInstance != null) {
            for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
                if (i.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) continue;
                ((IAgentClient)this.messagingClient).publishExports(i);
            }
        }
    }

    void processMsgSendInstances(MsgCmdSendInstances message) throws IOException {
        String appName = this.agent.getApplicationName();
        if (this.scopedInstance != null) {
            for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
                ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)new MsgNotifInstanceChanged(appName, i));
            }
        }
    }

    void processMsgSetScopedInstance(MsgCmdSetScopedInstance msg) throws IOException, PluginException {
        Instance newScopedInstance = msg.getScopedInstance();
        ArrayList instancesToProcess = new ArrayList();
        if (!InstanceHelpers.isTarget((Instance)newScopedInstance)) {
            this.logger.severe("The received instance is not a scoped one. Request to update the local model is dropped.");
        } else if (this.scopedInstance == null) {
            this.logger.fine("Setting the scoped instance.");
            this.scopedInstance = newScopedInstance;
            InstanceHelpers.removeOffScopeInstances((Instance)newScopedInstance);
            this.agent.setScopedInstance(newScopedInstance);
            instancesToProcess.addAll(InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance));
            ((IAgentClient)this.messagingClient).setExternalMapping(msg.getExternalExports());
            this.applicationBindings.putAll(msg.getApplicationBindings());
            AgentUtils.copyInstanceResources(this.scopedInstance, msg.getscriptResources());
            AgentUtils.executeScriptResources(InstanceHelpers.findInstanceDirectoryOnAgent((Instance)this.scopedInstance));
            if (this.scopedInstance.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) {
                this.scopedInstance.setStatus(Instance.InstanceStatus.DEPLOYED_STARTED);
                ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.agent.getApplicationName(), this.scopedInstance));
            }
            ((IAgentClient)this.messagingClient).listenToRequestsFromOtherAgents(ListenerCommand.START, this.scopedInstance);
        }
        for (Instance instanceToProcess : instancesToProcess) {
            ((IAgentClient)this.messagingClient).listenToExportsFromOtherAgents(ListenerCommand.START, instanceToProcess);
            ((IAgentClient)this.messagingClient).requestExportsFromOtherAgents(instanceToProcess);
        }
    }

    void processMsgRemoveInstance(MsgCmdRemoveInstance msg) throws IOException {
        boolean removed = false;
        Instance instance = InstanceHelpers.findInstanceByPath((Instance)this.scopedInstance, (String)msg.getInstancePath());
        if (instance == null) {
            this.logger.severe("No instance matched " + msg.getInstancePath() + " on the agent. Request to remove it from the model is dropped.");
        } else if (instance.getStatus() != Instance.InstanceStatus.NOT_DEPLOYED) {
            this.logger.severe("Instance " + msg.getInstancePath() + " cannot be removed. Instance status: " + instance.getStatus() + ".");
        } else if (instance.getParent() != null) {
            removed = true;
            instance.getParent().getChildren().remove(instance);
            this.logger.fine("Child instance " + msg.getInstancePath() + " was removed from the model.");
        } else {
            this.logger.fine("The root instance " + msg.getInstancePath() + " cannot be removed. The agent must be reboot and/or reconfigured.");
        }
        if (removed) {
            ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)new MsgNotifInstanceRemoved(this.agent.getApplicationName(), instance));
            for (Instance instanceToProcess : InstanceHelpers.buildHierarchicalList((Instance)instance)) {
                ((IAgentClient)this.messagingClient).listenToExportsFromOtherAgents(ListenerCommand.STOP, instanceToProcess);
            }
        }
    }

    void processMsgAddInstance(MsgCmdAddInstance msg) throws IOException, PluginException {
        Instance parentInstance = InstanceHelpers.findInstanceByPath((Instance)this.scopedInstance, (String)msg.getParentInstancePath());
        if (parentInstance == null) {
            this.logger.severe("The parent instance for " + msg.getParentInstancePath() + " was not found. The request to add a new instance is dropped.");
        } else {
            Component instanceComponent = ComponentHelpers.findComponentFrom((Component)parentInstance.getComponent(), (String)msg.getComponentName());
            if (instanceComponent == null) {
                this.logger.severe("The component " + msg.getComponentName() + " was not found in the local graph.");
            } else {
                Instance newInstance = new Instance(msg.getInstanceName()).component(instanceComponent);
                newInstance.channels.addAll(msg.getChannels());
                if (msg.getData() != null) {
                    newInstance.data.putAll(msg.getData());
                }
                if (msg.getOverridenExports() != null) {
                    newInstance.overriddenExports.putAll(msg.getOverridenExports());
                }
                ApplicationTemplate tempApp = new ApplicationTemplate("temp app");
                tempApp.getRootInstances().add(parentInstance);
                if (!InstanceHelpers.tryToInsertChildInstance((AbstractApplication)tempApp, (Instance)parentInstance, (Instance)newInstance)) {
                    this.logger.severe("The new '" + msg.getInstanceName() + "' instance could not be inserted into the local model.");
                } else {
                    ((IAgentClient)this.messagingClient).listenToExportsFromOtherAgents(ListenerCommand.START, newInstance);
                    ((IAgentClient)this.messagingClient).requestExportsFromOtherAgents(newInstance);
                }
            }
        }
    }

    void processMsgChangeInstanceState(MsgCmdChangeInstanceState msg) throws IOException, PluginException {
        Instance instance = InstanceHelpers.findInstanceByPath((Instance)this.scopedInstance, (String)msg.getInstancePath());
        if (instance == null) {
            this.logger.severe("No instance matched " + msg.getInstancePath() + " on the agent. Request to deploy it is dropped.");
        } else if (instance.getParent() == null) {
            this.logger.severe("No action on the root instance is permitted.");
        } else {
            PluginInterface plugin = this.agent.findPlugin(instance);
            if (plugin == null) {
                this.logger.severe("No plug-in was found to deploy " + msg.getInstancePath() + ".");
            } else {
                AbstractLifeCycleManager.build(instance, this.agent.getApplicationName(), (IAgentClient)this.messagingClient).changeInstanceState(instance, plugin, msg.getNewState(), msg.getFileNameToFileContent());
            }
        }
    }

    void processMsgRequestImport(MsgCmdRequestImport msg) throws IOException {
        for (Instance instance : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
            if (instance.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) continue;
            ((IAgentClient)this.messagingClient).publishExports(instance, msg.getComponentOrFacetName());
        }
    }

    void processMsgRemoveImport(MsgCmdRemoveImport msg, boolean realMessage) throws IOException, PluginException {
        String appName = this.agent.getApplicationName();
        if (realMessage && !msg.getApplicationOrContextName().equals(appName)) {
            this.removeCachedExternalImport(msg);
        }
        for (Instance instance : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
            Collection imports;
            Import toRemove;
            Set importPrefixes = VariableHelpers.findPrefixesForImportedVariables((Instance)instance);
            if (!importPrefixes.contains(msg.getComponentOrFacetName()) || (toRemove = ImportHelpers.findImportByExportingInstance((Collection)(imports = (Collection)instance.getImports().get(msg.getComponentOrFacetName())), (String)msg.getRemovedInstancePath())) == null) continue;
            imports.remove(toRemove);
            if (imports.isEmpty()) {
                instance.getImports().remove(msg.getComponentOrFacetName());
            }
            this.logger.fine("Removing import from " + InstanceHelpers.computeInstancePath((Instance)instance) + ". Removed exporting instance: " + msg.getRemovedInstancePath());
            ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)new MsgNotifInstanceChanged(appName, instance));
            PluginInterface plugin = this.agent.findPlugin(instance);
            if (plugin == null) {
                throw new PluginException("No plugin was found for " + InstanceHelpers.computeInstancePath((Instance)instance));
            }
            AbstractLifeCycleManager.build(instance, this.agent.getApplicationName(), (IAgentClient)this.messagingClient).updateStateFromImports(instance, plugin, toRemove, Instance.InstanceStatus.DEPLOYED_STOPPED);
        }
        this.startChildrenInstancesWaitingForAncestors();
    }

    void processMsgAddImport(MsgCmdAddImport msg) throws IOException, PluginException {
        if (!msg.getApplicationOrContextName().equals(this.agent.getApplicationName())) {
            Collection<Import> imports = this.applicationNameToExternalExports.get(msg.getApplicationOrContextName());
            if (imports == null) {
                imports = new LinkedHashSet<Import>();
                this.applicationNameToExternalExports.put(msg.getApplicationOrContextName(), imports);
            }
            imports.add(new Import(msg.getAddedInstancePath(), msg.getComponentOrFacetName(), msg.getExportedVariables()));
            Set<String> appNames = this.applicationBindings.get(msg.getComponentOrFacetName());
            if (appNames == null || !appNames.contains(msg.getApplicationOrContextName())) {
                this.logger.fine("An external export was received (" + msg.getComponentOrFacetName() + ") but did not match any of the bound applications.");
                return;
            }
        }
        String appName = this.agent.getApplicationName();
        for (Instance instance : InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance)) {
            Set importPrefixes = VariableHelpers.findPrefixesForImportedVariables((Instance)instance);
            if (!importPrefixes.contains(msg.getComponentOrFacetName()) || Objects.equals(InstanceHelpers.computeInstancePath((Instance)instance), msg.getAddedInstancePath())) continue;
            Import imp = ImportHelpers.buildTailoredImport((Instance)instance, (String)msg.getAddedInstancePath(), (String)msg.getComponentOrFacetName(), (Map)msg.getExportedVariables());
            this.logger.fine("Adding import to " + InstanceHelpers.computeInstancePath((Instance)instance) + ". New import: " + imp);
            ImportHelpers.addImport((Instance)instance, (String)msg.getComponentOrFacetName(), (Import)imp);
            ((IAgentClient)this.messagingClient).sendMessageToTheDm((Message)new MsgNotifInstanceChanged(appName, instance));
            PluginInterface plugin = this.agent.findPlugin(instance);
            if (plugin == null) {
                throw new PluginException("No plugin was found for " + InstanceHelpers.computeInstancePath((Instance)instance));
            }
            AbstractLifeCycleManager.build(instance, this.agent.getApplicationName(), (IAgentClient)this.messagingClient).updateStateFromImports(instance, plugin, imp, Instance.InstanceStatus.DEPLOYED_STARTED);
        }
        this.startChildrenInstancesWaitingForAncestors();
    }

    private void removeCachedExternalImport(MsgCmdRemoveImport msg) {
        Collection<Import> imports = this.applicationNameToExternalExports.get(msg.getApplicationOrContextName());
        if (imports != null) {
            Import toRemove = null;
            Iterator<Import> it = imports.iterator();
            while (it.hasNext() && toRemove == null) {
                Import cur = it.next();
                if (!cur.getInstancePath().equals(msg.getRemovedInstancePath())) continue;
                toRemove = cur;
            }
            if (toRemove != null) {
                imports.remove(toRemove);
            }
            if (imports.isEmpty()) {
                this.applicationNameToExternalExports.remove(msg.getApplicationOrContextName());
            }
        }
    }

    private void startChildrenInstancesWaitingForAncestors() throws IOException, PluginException {
        List childrenInstances = InstanceHelpers.buildHierarchicalList((Instance)this.scopedInstance);
        childrenInstances.remove(this.scopedInstance);
        for (Instance childInstance : childrenInstances) {
            if (childInstance.getStatus() != Instance.InstanceStatus.WAITING_FOR_ANCESTOR || childInstance.getParent().getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) continue;
            PluginInterface plugin = this.agent.findPlugin(childInstance);
            if (plugin == null) {
                this.logger.severe("No plug-in was found for " + InstanceHelpers.computeInstancePath((Instance)childInstance) + ".");
                continue;
            }
            AbstractLifeCycleManager.build(childInstance, this.agent.getApplicationName(), (IAgentClient)this.messagingClient).changeInstanceState(childInstance, plugin, Instance.InstanceStatus.DEPLOYED_STARTED, null);
        }
    }
}

