/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.agents.DataHelpers;
import net.roboconf.core.utils.Utils;

public final class AgentProperties {
    private String applicationName;
    private String ipAddress;
    private String scopedInstancePath;
    private String domain;
    private Map<String, String> messagingConfiguration;

    AgentProperties() {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getScopedInstancePath() {
        return this.scopedInstancePath;
    }

    public void setScopedInstancePath(String scopedInstancePath) {
        this.scopedInstancePath = scopedInstancePath;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Map<String, String> getMessagingConfiguration() {
        return this.messagingConfiguration;
    }

    public void setMessagingConfiguration(Map<String, String> messagingConfiguration) {
        this.messagingConfiguration = messagingConfiguration;
    }

    public String validate() {
        String result = null;
        if (this.messagingConfiguration == null || this.messagingConfiguration.isEmpty()) {
            result = "The message configuration cannot be null or empty.";
        } else if (this.messagingConfiguration.get("net.roboconf.messaging.type") == null) {
            result = "The message configuration does not contain the messaging type.";
        } else if (Utils.isEmptyOrWhitespaces((String)this.applicationName)) {
            result = "The application name cannot be null or empty.";
        } else if (Utils.isEmptyOrWhitespaces((String)this.scopedInstancePath)) {
            result = "The scoped instance's path cannot be null or empty.";
        }
        return result;
    }

    public static AgentProperties readIaasProperties(String rawProperties, Logger logger) throws IOException {
        Properties props = new Properties();
        if (rawProperties != null) {
            props = DataHelpers.readUserData((String)rawProperties);
        }
        return AgentProperties.readIaasProperties(props);
    }

    public static AgentProperties readIaasProperties(Properties props) {
        AgentProperties result = new AgentProperties();
        result.setApplicationName(AgentProperties.updatedField(props, "application.name"));
        result.setScopedInstancePath(AgentProperties.updatedField(props, "scoped.instance.path"));
        result.setDomain(AgentProperties.updatedField(props, "domain"));
        LinkedHashMap<String, String> messagingConfiguration = new LinkedHashMap<String, String>();
        List<String> toSkip = Arrays.asList("application.name", "domain", "scoped.instance.path");
        for (String k : props.stringPropertyNames()) {
            if (toSkip.contains(k)) continue;
            messagingConfiguration.put(k, AgentProperties.updatedField(props, k));
        }
        result.setMessagingConfiguration(Collections.unmodifiableMap(messagingConfiguration));
        return result;
    }

    private static String updatedField(Properties props, String fieldName) {
        String property = props.getProperty(fieldName);
        if (property != null) {
            property = property.replace("\\:", ":");
        }
        return property;
    }
}

