/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.misc;

import java.util.TimerTask;
import java.util.logging.Logger;
import net.roboconf.agent.internal.Agent;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifHeartbeat;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClientAgent;

public class HeartbeatTask
extends TimerTask {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Agent agent;

    public HeartbeatTask(Agent agent) {
        this.agent = agent;
    }

    @Override
    public void run() {
        try {
            MsgNotifHeartbeat heartBeat = new MsgNotifHeartbeat(this.agent.getApplicationName(), this.agent.getScopedInstancePath(), this.agent.getIpAddress());
            heartBeat.setModelRequired(this.agent.needsModel());
            this.logger.finer("Model is required by the agent: " + heartBeat.isModelRequired());
            ReconfigurableClientAgent messagingClient = this.agent.getMessagingClient();
            if (messagingClient != null && messagingClient.isConnected()) {
                messagingClient.sendMessageToTheDm((Message)heartBeat);
            }
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }
}

