/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.misc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.roboconf.agent.internal.AgentProperties;
import net.roboconf.agent.internal.misc.AgentUtils;
import net.roboconf.core.utils.Utils;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class UserDataUtils {
    public static final String CONF_FILE_AGENT = "net.roboconf.agent.configuration.cfg";

    private UserDataUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentProperties findParametersForAmazonOrOpenStack(Logger logger) {
        String userData = "";
        InputStream in = null;
        try {
            URL userDataUrl = new URL("http://169.254.169.254/latest/user-data");
            in = userDataUrl.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
            userData = os.toString("UTF-8");
        }
        catch (IOException e) {
            logger.severe("The agent properties could not be read. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        AgentProperties result = null;
        in = null;
        try {
            result = AgentProperties.readIaasProperties(userData, logger);
            URL userDataUrl = new URL("http://169.254.169.254/latest/meta-data/public-ipv4");
            in = userDataUrl.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
            String ip = os.toString("UTF-8");
            if (!AgentUtils.isValidIP(ip)) {
                Utils.closeQuietly((InputStream)in);
                userDataUrl = new URL("http://169.254.169.254/latest/meta-data/local-ipv4");
                in = userDataUrl.openStream();
                os = new ByteArrayOutputStream();
                Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
                ip = os.toString("UTF-8");
            }
            if (!AgentUtils.isValidIP(ip)) {
                throw new IOException("No IP address could be retrieved (either public-ipv4 or local-ipv4)");
            }
            result.setIpAddress(os.toString("UTF-8"));
        }
        catch (IOException e) {
            logger.severe("The network properties could not be read. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        finally {
            Utils.closeQuietly((InputStream)in);
        }
        return result;
    }

    public static AgentProperties findParametersForAzure(Logger logger) {
        String userData = "";
        try {
            String userDataEncoded = UserDataUtils.getValueOfTagInXMLFile("/var/lib/waagent/ovf-env.xml", "CustomData");
            userData = new String(Base64.decodeBase64(userDataEncoded.getBytes("UTF-8")), "UTF-8");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe("The agent properties could not be read. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        AgentProperties result = null;
        try {
            result = AgentProperties.readIaasProperties(userData, logger);
            String publicIPAddress = UserDataUtils.getSpecificAttributeOfTagInXMLFile("/var/lib/waagent/SharedConfig.xml", "Endpoint", "loadBalancedPublicAddress");
            result.setIpAddress(publicIPAddress);
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.severe("The agent could not retrieve a public IP address. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        catch (IOException e) {
            logger.severe("The agent could not retrieve its configuration. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        return result;
    }

    public static AgentProperties findParametersForVmware(Logger logger) {
        File propertiesFile = new File("/tmp/roboconf.properties");
        try {
            int retries = 30;
            while (!(propertiesFile.exists() && propertiesFile.canRead() || retries-- <= 0)) {
                logger.fine("Agent tries to read properties file " + propertiesFile + ": trial #" + (30 - retries));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Can't read properties file: " + e);
                }
            }
            return AgentProperties.readIaasProperties(Utils.readPropertiesFile((File)propertiesFile));
        }
        catch (IOException e) {
            logger.fine("Agent failed to read properties file " + propertiesFile);
            return null;
        }
    }

    public static void reconfigureMessaging(String etcDir, Map<String, String> msgData) throws IOException {
        String messagingType = msgData.get("net.roboconf.messaging.type");
        Logger.getLogger(UserDataUtils.class.getName()).fine("Messaging type for reconfiguration: " + messagingType);
        if (!Utils.isEmptyOrWhitespaces((String)etcDir)) {
            Properties props = new Properties();
            props.putAll(msgData);
            props.remove("messaging-type");
            File f = new File(etcDir, "net.roboconf.messaging." + messagingType + ".cfg");
            Utils.writePropertiesFile((Properties)props, (File)f);
            f = new File(etcDir, CONF_FILE_AGENT);
            props = Utils.readPropertiesFileQuietly((File)f, (Logger)Logger.getLogger(UserDataUtils.class.getName()));
            props.put("messaging-type", messagingType);
            Utils.writePropertiesFile((Properties)props, (File)f);
        }
    }

    private static String getValueOfTagInXMLFile(String filePath, String tagName) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(tagName);
        String valueOfTagName = "";
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            valueOfTagName = nNode.getTextContent();
        }
        return valueOfTagName;
    }

    private static String getSpecificAttributeOfTagInXMLFile(String filePath, String tagName, String attrName) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(tagName);
        Node aNode = nList.item(2);
        NamedNodeMap attributes = aNode.getAttributes();
        String attrValue = "";
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node theAttribute = attributes.item(a);
            if (!attrName.equals(theAttribute.getNodeName())) continue;
            attrValue = theAttribute.getTextContent().split(":")[0];
        }
        return attrValue;
    }
}

