/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Recoverable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.api.utils.MessagingUtils;
import net.roboconf.messaging.api.utils.SerializationUtils;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfConsumer;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfRecoveryListener;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfReturnListener;
import net.roboconf.messaging.rabbitmq.internal.utils.RabbitMqUtils;

public class RabbitMqClient
implements IMessagingClient {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String messageServerIp;
    private final String messageServerUsername;
    private final String messageServerPassword;
    private final WeakReference<ReconfigurableClient<?>> reconfigurable;
    private LinkedBlockingQueue<Message> messageQueue;
    private MessagingContext.RecipientKind ownerKind;
    private String applicationName;
    private String scopedInstancePath;
    private String domain;
    String consumerTag;
    Channel channel;

    protected RabbitMqClient(ReconfigurableClient<?> reconfigurable, String ip, String username, String password) {
        this(reconfigurable, ip, username, password, reconfigurable.getOwnerKind());
    }

    protected RabbitMqClient(ReconfigurableClient<?> reconfigurable, String ip, String username, String password, MessagingContext.RecipientKind ownerKind) {
        this.reconfigurable = new WeakReference(reconfigurable);
        this.messageServerIp = ip;
        this.messageServerUsername = username;
        this.messageServerPassword = password;
        this.ownerKind = ownerKind;
    }

    public final ReconfigurableClient<?> getReconfigurableClient() {
        return (ReconfigurableClient)this.reconfigurable.get();
    }

    public final void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        this.messageQueue = messageQueue;
    }

    public final synchronized boolean isConnected() {
        return this.channel != null;
    }

    public final String getMessagingType() {
        return "rabbitmq";
    }

    public final Map<String, String> getConfiguration() {
        LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
        configuration.put("net.roboconf.messaging.type", "rabbitmq");
        configuration.put("net.roboconf.messaging.rabbitmq.server.ip", this.messageServerIp);
        configuration.put("net.roboconf.messaging.rabbitmq.server.username", this.messageServerUsername);
        configuration.put("net.roboconf.messaging.rabbitmq.server.password", this.messageServerPassword);
        return Collections.unmodifiableMap(configuration);
    }

    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        this.ownerKind = ownerKind;
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
        this.domain = domain;
        this.logger.fine("Owner properties changed to " + this.getId());
    }

    public void openConnection() throws IOException {
        this.logger.info(this.getId() + " is opening a connection to RabbitMQ.");
        if (this.isConnected()) {
            this.logger.info(this.getId() + " has already a connection to RabbitMQ.");
            return;
        }
        ConnectionFactory factory = new ConnectionFactory();
        RabbitMqUtils.configureFactory(factory, this.messageServerIp, this.messageServerUsername, this.messageServerPassword);
        this.channel = factory.newConnection().createChannel();
        this.logger.info(this.getId() + " established a new connection with RabbitMQ. Channel # " + this.channel.getChannelNumber());
        this.channel.addReturnListener(new RoboconfReturnListener());
        ((Recoverable)((Object)this.channel)).addRecoveryListener(new RoboconfRecoveryListener());
        RabbitMqUtils.declareGlobalExchanges(this.domain, this.channel);
        RabbitMqUtils.declareApplicationExchanges(this.domain, this.applicationName, this.channel);
        String queueName = this.getQueueName();
        this.channel.queueDeclare(queueName, true, false, true, null);
        RoboconfConsumer consumer = new RoboconfConsumer(this.getId(), this.channel, this.messageQueue);
        consumer.handleConsumeOk(queueName);
        this.consumerTag = this.channel.basicConsume(queueName, true, consumer);
        this.logger.finer("A new consumer tag was created: " + this.consumerTag);
    }

    public void closeConnection() throws IOException {
        StringBuilder sb = new StringBuilder(this.getId() + " is closing its connection to RabbitMQ.");
        if (this.channel != null) {
            sb.append(" Channel # ").append(this.channel.getChannelNumber());
        }
        this.logger.info(sb.toString());
        if (this.channel != null && this.channel.isOpen() && this.consumerTag != null) {
            this.channel.basicCancel(this.consumerTag);
            this.logger.finer("A consumer tag was cancelled: " + this.consumerTag);
        }
        this.consumerTag = null;
        if (this.isConnected()) {
            this.logger.finer("Closing the connection and the channel # " + this.channel.getChannelNumber());
            RabbitMqUtils.closeConnection(this.channel);
        }
        this.channel = null;
    }

    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.channel.exchangeDelete(RabbitMqUtils.buildExchangeNameForAgent(this.domain, application.getName()));
        this.logger.fine("Messaging artifacts were deleted for application " + application);
    }

    public void publish(MessagingContext ctx, Message msg) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String routingKey = ctx.getTopicName();
        this.logger.fine("A message is about to be published to " + exchangeName + " with routing key = " + routingKey);
        AMQP.BasicProperties props = null;
        if (ctx.getKind() == MessagingContext.RecipientKind.DM) {
            props = new AMQP.BasicProperties.Builder().expiration("500").build();
        }
        boolean mandatory = false;
        if (this.ownerKind == MessagingContext.RecipientKind.DM && this.ownerKind != ctx.getKind() || this.ownerKind == MessagingContext.RecipientKind.AGENTS && ctx.getKind() == MessagingContext.RecipientKind.DM) {
            mandatory = true;
        }
        this.channel.basicPublish(exchangeName, routingKey, mandatory, false, props, SerializationUtils.serializeObject((Serializable)msg));
    }

    public void subscribe(MessagingContext ctx) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String queueName = this.getQueueName();
        this.logger.fine("Binding queue " + queueName + " and exchange " + exchangeName + " with routing key = " + ctx.getTopicName());
        this.channel.queueBind(queueName, exchangeName, ctx.getTopicName());
    }

    public void unsubscribe(MessagingContext ctx) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String queueName = this.getQueueName();
        this.logger.fine("Unbinding queue " + queueName + " and exchange " + exchangeName + " with routing key = " + ctx.getTopicName());
        this.channel.queueUnbind(queueName, exchangeName, ctx.getTopicName());
    }

    String getQueueName() {
        StringBuilder queueName = new StringBuilder();
        queueName.append(this.domain);
        queueName.append(".");
        if (this.ownerKind == MessagingContext.RecipientKind.DM) {
            queueName.append("roboconf-dm");
        } else {
            queueName.append(this.applicationName);
            queueName.append(".");
            queueName.append(MessagingUtils.escapeInstancePath((String)this.scopedInstancePath));
        }
        return queueName.toString();
    }

    String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(this.domain);
        sb.append(" ] ");
        if (this.ownerKind == MessagingContext.RecipientKind.DM) {
            sb.append("DM");
        } else {
            sb.append(this.scopedInstancePath);
            sb.append(" @ ");
            sb.append(this.applicationName);
        }
        return sb.toString();
    }
}

