/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.factory.IMessagingClientFactory;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.rabbitmq.internal.RabbitMqClient;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class RabbitMqClientFactory
implements IMessagingClientFactory,
Pojo {
    InstanceManager __IM;
    private boolean __FmessageServerIp;
    String messageServerIp;
    private boolean __FmessageServerUsername;
    String messageServerUsername;
    private boolean __FmessageServerPassword;
    String messageServerPassword;
    private boolean __Fclients;
    final Set<RabbitMqClient> clients;
    private boolean __Flogger;
    private final Logger logger;
    boolean __MsetMessageServerIp$java_lang_String;
    boolean __MsetMessageServerUsername$java_lang_String;
    boolean __MsetMessageServerPassword$java_lang_String;
    boolean __Mreconfigure;
    boolean __Mstop;
    boolean __MresetClients$boolean;
    boolean __MgetType;
    boolean __McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient;
    boolean __MsetConfiguration$java_util_Map;

    String __getmessageServerIp() {
        if (!this.__FmessageServerIp) {
            return this.messageServerIp;
        }
        return (String)this.__IM.onGet((Object)this, "messageServerIp");
    }

    void __setmessageServerIp(String string) {
        if (!this.__FmessageServerIp) {
            this.messageServerIp = string;
            return;
        }
        this.__IM.onSet((Object)this, "messageServerIp", (Object)string);
    }

    String __getmessageServerUsername() {
        if (!this.__FmessageServerUsername) {
            return this.messageServerUsername;
        }
        return (String)this.__IM.onGet((Object)this, "messageServerUsername");
    }

    void __setmessageServerUsername(String string) {
        if (!this.__FmessageServerUsername) {
            this.messageServerUsername = string;
            return;
        }
        this.__IM.onSet((Object)this, "messageServerUsername", (Object)string);
    }

    String __getmessageServerPassword() {
        if (!this.__FmessageServerPassword) {
            return this.messageServerPassword;
        }
        return (String)this.__IM.onGet((Object)this, "messageServerPassword");
    }

    void __setmessageServerPassword(String string) {
        if (!this.__FmessageServerPassword) {
            this.messageServerPassword = string;
            return;
        }
        this.__IM.onSet((Object)this, "messageServerPassword", (Object)string);
    }

    Set __getclients() {
        if (!this.__Fclients) {
            return this.clients;
        }
        return (Set)this.__IM.onGet((Object)this, "clients");
    }

    void __setclients(Set set) {
        if (!this.__Fclients) {
            this.clients = set;
            return;
        }
        this.__IM.onSet((Object)this, "clients", (Object)set);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public RabbitMqClientFactory() {
        this(null);
    }

    private RabbitMqClientFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setclients(Collections.newSetFromMap(new WeakHashMap()));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public synchronized void setMessageServerIp(String messageServerIp) {
        if (!this.__MsetMessageServerIp$java_lang_String) {
            this.__M_setMessageServerIp(messageServerIp);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMessageServerIp$java_lang_String", new Object[]{messageServerIp});
            this.__M_setMessageServerIp(messageServerIp);
            this.__IM.onExit((Object)this, "setMessageServerIp$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMessageServerIp$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setMessageServerIp(String messageServerIp) {
        this.__setmessageServerIp(messageServerIp);
        this.__getlogger().finer("Server IP set to " + messageServerIp);
    }

    public synchronized void setMessageServerUsername(String messageServerUsername) {
        if (!this.__MsetMessageServerUsername$java_lang_String) {
            this.__M_setMessageServerUsername(messageServerUsername);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMessageServerUsername$java_lang_String", new Object[]{messageServerUsername});
            this.__M_setMessageServerUsername(messageServerUsername);
            this.__IM.onExit((Object)this, "setMessageServerUsername$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMessageServerUsername$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setMessageServerUsername(String messageServerUsername) {
        this.__setmessageServerUsername(messageServerUsername);
        this.__getlogger().finer("Server username set to " + messageServerUsername);
    }

    public synchronized void setMessageServerPassword(String messageServerPassword) {
        if (!this.__MsetMessageServerPassword$java_lang_String) {
            this.__M_setMessageServerPassword(messageServerPassword);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMessageServerPassword$java_lang_String", new Object[]{messageServerPassword});
            this.__M_setMessageServerPassword(messageServerPassword);
            this.__IM.onExit((Object)this, "setMessageServerPassword$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMessageServerPassword$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setMessageServerPassword(String messageServerPassword) {
        this.__setmessageServerPassword(messageServerPassword);
        this.__getlogger().finer("Server password set to " + messageServerPassword);
    }

    public void reconfigure() {
        if (!this.__Mreconfigure) {
            this.__M_reconfigure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconfigure", new Object[0]);
            this.__M_reconfigure();
            this.__IM.onExit((Object)this, "reconfigure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconfigure", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure() {
        this.__getlogger().fine("Rabbit MQ clients are about to be reconfigured.");
        this.resetClients(false);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.resetClients(true);
    }

    private void resetClients(boolean shutdown) {
        if (!this.__MresetClients$boolean) {
            this.__M_resetClients(shutdown);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resetClients$boolean", new Object[]{new Boolean(shutdown)});
            this.__M_resetClients(shutdown);
            this.__IM.onExit((Object)this, "resetClients$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resetClients$boolean", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_resetClients(boolean shutdown) {
        ArrayList clients;
        RabbitMqClientFactory rabbitMqClientFactory = this;
        synchronized (rabbitMqClientFactory) {
            clients = new ArrayList(this.__getclients());
            this.__getclients().clear();
        }
        for (RabbitMqClient client : clients) {
            try {
                ReconfigurableClient<?> reconfigurable = client.getReconfigurableClient();
                if (shutdown) {
                    reconfigurable.closeConnection();
                    continue;
                }
                reconfigurable.switchMessagingType("rabbitmq");
            }
            catch (Throwable t) {
                this.__getlogger().warning("A client has thrown an exception on reconfiguration: " + client);
                Utils.logException((Logger)this.__getlogger(), (Throwable)new RuntimeException(t));
            }
        }
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__M_getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__M_getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getType() {
        return "rabbitmq";
    }

    public IMessagingClient createClient(ReconfigurableClient<?> parent) {
        IMessagingClient iMessagingClient;
        if (!this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient) {
            return this.__M_createClient(parent);
        }
        try {
            this.__IM.onEntry((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", new Object[]{parent});
            iMessagingClient = this.__M_createClient(parent);
            this.__IM.onExit((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", (Object)iMessagingClient);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", throwable);
            throw throwable;
        }
        return iMessagingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessagingClient __M_createClient(ReconfigurableClient<?> parent) {
        this.__getlogger().fine("Creating a new Rabbit MQ client with owner = " + parent.getOwnerKind());
        RabbitMqClient client = new RabbitMqClient(parent, this.__getmessageServerIp(), this.__getmessageServerUsername(), this.__getmessageServerPassword());
        RabbitMqClientFactory rabbitMqClientFactory = this;
        synchronized (rabbitMqClientFactory) {
            this.__getclients().add(client);
        }
        this.__getlogger().finer("A new Rabbit MQ client was created.");
        return client;
    }

    public boolean setConfiguration(Map<String, String> configuration) {
        boolean bl;
        if (!this.__MsetConfiguration$java_util_Map) {
            return this.__M_setConfiguration(configuration);
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$java_util_Map", new Object[]{configuration});
            bl = this.__M_setConfiguration(configuration);
            this.__IM.onExit((Object)this, "setConfiguration$java_util_Map", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$java_util_Map", throwable);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean __M_setConfiguration(Map<String, String> configuration) {
        boolean result = false;
        String type = configuration.get("net.roboconf.messaging.type");
        result = "rabbitmq".equals(type);
        if (result) {
            String ip = Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.server.ip", (String)"localhost");
            String username = Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.server.username", (String)"guest");
            String password = Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.server.password", (String)"guest");
            boolean hasChanged = false;
            RabbitMqClientFactory rabbitMqClientFactory = this;
            synchronized (rabbitMqClientFactory) {
                if (!Objects.equals(this.__getmessageServerIp(), ip)) {
                    this.setMessageServerIp(ip);
                    hasChanged = true;
                }
                if (!Objects.equals(this.__getmessageServerUsername(), username)) {
                    this.setMessageServerUsername(username);
                    hasChanged = true;
                }
                if (!Objects.equals(this.__getmessageServerPassword(), password)) {
                    this.setMessageServerPassword(password);
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                this.reconfigure();
            }
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("clients")) {
                this.__Fclients = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("messageServerIp")) {
                this.__FmessageServerIp = true;
            }
            if (set.contains("messageServerPassword")) {
                this.__FmessageServerPassword = true;
            }
            if (set.contains("messageServerUsername")) {
                this.__FmessageServerUsername = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setMessageServerIp$java_lang_String")) {
                this.__MsetMessageServerIp$java_lang_String = true;
            }
            if (set.contains("setMessageServerUsername$java_lang_String")) {
                this.__MsetMessageServerUsername$java_lang_String = true;
            }
            if (set.contains("setMessageServerPassword$java_lang_String")) {
                this.__MsetMessageServerPassword$java_lang_String = true;
            }
            if (set.contains("reconfigure")) {
                this.__Mreconfigure = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("resetClients$boolean")) {
                this.__MresetClients$boolean = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
            if (set.contains("createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient")) {
                this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient = true;
            }
            if (set.contains("setConfiguration$java_util_Map")) {
                this.__MsetConfiguration$java_util_Map = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

