/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.utils.SerializationUtils;

public class RoboconfReturnListener
implements ReturnListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String messageType = "undetermined";
        try {
            Message msg = SerializationUtils.deserializeObject((byte[])body);
            messageType = msg.getClass().getName();
        }
        catch (Exception e) {
            this.logger.severe("Failed to deserialize a message object.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        if (this.logger.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder();
            sb.append("A message sent by a RabbitMQ client was not received by any queue.\n");
            sb.append("Message type: " + messageType + '\n');
            sb.append("Routing key: " + routingKey + '\n');
            sb.append("Reason: " + replyText);
            this.logger.warning(sb.toString());
        }
    }
}

