/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal.utils;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Map;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.MessagingContext;

public final class RabbitMqUtils {
    private RabbitMqUtils() {
    }

    public static void configureFactory(ConnectionFactory factory, String messageServerIp, String messageServerUsername, String messageServerPassword) throws IOException {
        if (messageServerIp != null) {
            Map.Entry entry = Utils.findUrlAndPort((String)messageServerIp);
            factory.setHost((String)entry.getKey());
            if ((Integer)entry.getValue() > 0) {
                factory.setPort((Integer)entry.getValue());
            }
        }
        factory.setUsername(messageServerUsername);
        factory.setPassword(messageServerPassword);
        factory.setConnectionTimeout(5000);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        factory.setTopologyRecoveryEnabled(true);
    }

    public static void closeConnection(Channel channel) throws IOException {
        if (channel != null) {
            if (channel.isOpen()) {
                channel.close();
            }
            if (channel.getConnection().isOpen()) {
                channel.getConnection().close();
            }
        }
    }

    public static void declareApplicationExchanges(String domain, String applicationName, Channel channel) throws IOException {
        if (applicationName != null) {
            String exch = RabbitMqUtils.buildExchangeNameForAgent(domain, applicationName);
            channel.exchangeDeclare(exch, "topic");
        }
    }

    public static void declareGlobalExchanges(String domain, Channel channel) throws IOException {
        channel.exchangeDeclare(RabbitMqUtils.buildExchangeNameForTheDm(domain), "topic");
        channel.exchangeDeclare(RabbitMqUtils.buildExchangeNameForInterApp(domain), "topic");
    }

    public static String buildExchangeNameForAgent(String domain, String applicationName) {
        return domain + "." + applicationName + ".agents";
    }

    public static String buildExchangeNameForTheDm(String domain) {
        return domain + "." + "roboconf.dm";
    }

    public static String buildExchangeNameForInterApp(String domain) {
        return domain + "." + "roboconf.inter-app";
    }

    public static String buildExchangeName(MessagingContext ctx) {
        String exchangeName = ctx.getKind() == MessagingContext.RecipientKind.DM ? RabbitMqUtils.buildExchangeNameForTheDm(ctx.getDomain()) : (ctx.getKind() == MessagingContext.RecipientKind.INTER_APP ? RabbitMqUtils.buildExchangeNameForInterApp(ctx.getDomain()) : RabbitMqUtils.buildExchangeNameForAgent(ctx.getDomain(), ctx.getApplicationName()));
        return exchangeName;
    }
}

