/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.agent.AgentMessagingInterface;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;

public class MonitoringRunnable
implements Runnable {
    private static final String COMMENT_DELIMITER = "#";
    static final String RULE_BEGINNING = "[event";
    static final String EVENT_PATTERN = "\\[event\\s+(\\S+)\\s+(\\S+)\\s*\\]";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<IMonitoringHandler> handlers;
    private final AgentMessagingInterface agentInterface;
    private final Pattern eventPattern;
    private boolean handlersWereInitialized = false;

    public MonitoringRunnable(AgentMessagingInterface agentInterface, List<IMonitoringHandler> handlers) {
        this.agentInterface = agentInterface;
        this.handlers = handlers;
        this.eventPattern = Pattern.compile(EVENT_PATTERN, 2);
    }

    @Override
    public void run() {
        this.logger.fine("Monitoring Task is being invoked.");
        if (this.agentInterface.getScopedInstance() == null) {
            this.logger.fine("The agent's model has not yet been initialized. Monitoring cannot work yet.");
            return;
        }
        if (!this.handlersWereInitialized) {
            for (IMonitoringHandler handler : this.handlers) {
                String scopedInstancePath = InstanceHelpers.computeInstancePath((Instance)this.agentInterface.getScopedInstance());
                handler.setAgentId(this.agentInterface.getApplicationName(), scopedInstancePath);
            }
            this.handlersWereInitialized = true;
        }
        for (Instance inst : InstanceHelpers.buildHierarchicalList((Instance)this.agentInterface.getScopedInstance())) {
            Properties params;
            String fileContent;
            File dir;
            File measureFile;
            if (inst.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED || !(measureFile = new File(dir = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)inst), inst.getComponent().getName() + ".measures")).exists()) continue;
            this.logger.fine("A file with measure rules was found for instance '" + inst + "'.");
            try {
                fileContent = Utils.readFileContent((File)measureFile);
            }
            catch (IOException e) {
                this.logger.warning("A problem occurred while reading the content for measure rules of instance '" + inst + "'.");
                Utils.logException((Logger)this.logger, (Throwable)e);
                continue;
            }
            try {
                File paramFile = new File(dir, inst.getComponent().getName() + ".measures" + ".properties");
                params = Utils.readPropertiesFile((File)paramFile);
                this.logger.fine("A file with measure parameters (properties) was found for instance '" + inst + "'.");
            }
            catch (IOException e1) {
                params = null;
            }
            for (MonitoringHandlerRun bean : this.extractRuleSections(measureFile, fileContent, params)) {
                try {
                    IMonitoringHandler handler = this.findHandlerByName(bean.handlerName);
                    if (handler == null) {
                        this.logger.warning("No handler was found with the ID '" + bean.handlerName + "'. The rule is skipped.");
                        continue;
                    }
                    handler.reset(inst, bean.eventId, bean.rawRulesText);
                    MsgNotifAutonomic msg = handler.process();
                    if (msg == null) continue;
                    this.agentInterface.getMessagingClient().sendMessageToTheDm((Message)msg);
                }
                catch (IOException e) {
                    this.logger.warning("A problem occurred while the agent monitoring was sending a message to the DM. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
    }

    List<MonitoringHandlerRun> extractRuleSections(File file, String fileContent, Properties params) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> sections = new ArrayList<String>();
        for (String s : Arrays.asList(fileContent.trim().split("\n"))) {
            if ((s = s.trim()).length() == 0 || s.startsWith(COMMENT_DELIMITER)) continue;
            if (s.toLowerCase().startsWith(RULE_BEGINNING)) {
                this.addSectionIfNotEmpty(sections, sb.toString());
                sb.setLength(0);
            }
            sb.append(Utils.expandTemplate((String)s, (Properties)params) + "\n");
        }
        this.addSectionIfNotEmpty(sections, sb.toString());
        ArrayList<MonitoringHandlerRun> result = new ArrayList<MonitoringHandlerRun>();
        for (String s : sections) {
            Matcher m = this.eventPattern.matcher(s);
            if (!m.find()) continue;
            s = s.substring(m.end()).trim();
            MonitoringHandlerRun bean = new MonitoringHandlerRun();
            bean.handlerName = m.group(1);
            bean.eventId = m.group(2);
            bean.rawRulesText = s;
            result.add(bean);
        }
        return result;
    }

    private void addSectionIfNotEmpty(List<String> sections, String section) {
        if (!Utils.isEmptyOrWhitespaces((String)section)) {
            sections.add(section);
        }
    }

    private IMonitoringHandler findHandlerByName(String name) {
        IMonitoringHandler result = null;
        Iterator<IMonitoringHandler> it = this.handlers.iterator();
        while (it.hasNext() && result == null) {
            IMonitoringHandler curr = it.next();
            if (!name.equalsIgnoreCase(curr.getName())) continue;
            result = curr;
        }
        return result;
    }

    static class MonitoringHandlerRun {
        public String handlerName;
        public String eventId;
        public String rawRulesText;

        MonitoringHandlerRun() {
        }
    }
}

