/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal.nagios;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.agent.monitoring.internal.nagios.LiveStatusClient;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;

public class NagiosHandler
implements IMonitoringHandler {
    static final String HANDLER_NAME = "nagios";
    static final String NAGIOS_CONFIG = "nagios configuration at";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String applicationName;
    private String scopedInstancePath;
    private String eventId;
    String nagiosInstructions;
    String host;
    int port = -1;

    public String getName() {
        return HANDLER_NAME;
    }

    public void setAgentId(String applicationName, String scopedInstancePath) {
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
    }

    public void reset(Instance associatedInstance, String eventId, String fileContent) {
        this.eventId = eventId;
        this.nagiosInstructions = fileContent.trim();
        if (this.nagiosInstructions.toLowerCase().startsWith(NAGIOS_CONFIG)) {
            String nagiosConfig = this.nagiosInstructions.substring(NAGIOS_CONFIG.length());
            this.nagiosInstructions = "";
            int pos = nagiosConfig.indexOf(10);
            if (pos > 0) {
                this.nagiosInstructions = nagiosConfig.substring(pos).trim();
                nagiosConfig = nagiosConfig.substring(0, pos).trim();
            }
            Map.Entry entry = Utils.findUrlAndPort((String)nagiosConfig);
            this.host = (String)entry.getKey();
            this.port = (Integer)entry.getValue();
        }
    }

    public MsgNotifAutonomic process() {
        LiveStatusClient client = new LiveStatusClient(this.host, this.port);
        MsgNotifAutonomic result = null;
        try {
            String liveStatusResponse = client.queryLivestatus(this.nagiosInstructions);
            result = new MsgNotifAutonomic(this.applicationName, this.scopedInstancePath, this.eventId, liveStatusResponse);
        }
        catch (UnknownHostException e) {
            this.logger.warning("Uknown host exception. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warning("I/O exception. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return result;
    }
}

