/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;

public class RestHandler
implements IMonitoringHandler {
    static final String HANDLER_NAME = "rest";
    private static final String USER_AGENT = "Mozilla/34.0";
    private static final String CHECK = "check";
    private static final String THAT = "that";
    private static final String CONDITION_PATTERN = "(\\w+)\\s+(==|=|>=|>|<=|<)\\s+(\\S+)";
    private static final String WHOLE_PATTERN = "check\\s+(\\S+)\\s+that\\s+(\\w+)\\s+(==|=|>=|>|<=|<)\\s+(\\S+)";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String applicationName;
    private String scopedInstancePath;
    private String eventId;
    String url;
    String conditionParameter;
    String conditionOperator;
    String conditionThreshold;

    public String getName() {
        return HANDLER_NAME;
    }

    public void setAgentId(String applicationName, String scopedInstancePath) {
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
    }

    public void reset(Instance associatedInstance, String eventId, String rawRulesText) {
        this.eventId = eventId;
        Matcher m = Pattern.compile(WHOLE_PATTERN, 2).matcher(rawRulesText);
        if (m.find()) {
            this.url = m.group(1);
            this.conditionParameter = m.group(2);
            this.conditionOperator = m.group(3);
            this.conditionThreshold = m.group(4);
        } else {
            this.logger.severe("Invalid content for the 'rest' handler in the agent's monitoring.");
        }
    }

    public MsgNotifAutonomic process() {
        String s;
        String[] kv;
        MsgNotifAutonomic result = null;
        String response = null;
        if (this.url != null) {
            response = this.url.startsWith("https:") ? this.httpsQuery() : this.httpQuery();
        }
        response = response != null ? response.replace('{', ' ').replace('}', ' ').trim() : "";
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = response.split("\\n");
        int n = stringArray.length;
        for (int i = 0; i < n && (kv = (s = stringArray[i]).split(":")).length == 2; ++i) {
            map.put(kv[0].replace("\"", " ").trim(), kv[1]);
        }
        if (map.isEmpty()) {
            this.logger.warning("The REST response could not be parsed.");
            this.logger.finer("Received response: " + response);
        } else if (this.evalCondition(map)) {
            result = new MsgNotifAutonomic(this.applicationName, this.scopedInstancePath, this.eventId, response.toString());
        }
        return result;
    }

    boolean evalCondition(Map<String, String> map) {
        boolean result = false;
        String value = map.get(this.conditionParameter);
        if (value != null) {
            try {
                Double doubleValue = Double.parseDouble(value);
                Double thresholdValue = Double.parseDouble(this.conditionThreshold);
                int comparison = doubleValue.compareTo(thresholdValue);
                result = ">".equals(this.conditionOperator) ? comparison > 0 : (">=".equals(this.conditionOperator) ? comparison >= 0 : ("<".equals(this.conditionOperator) ? comparison < 0 : ("<=".equals(this.conditionOperator) ? comparison <= 0 : comparison == 0)));
            }
            catch (NumberFormatException e) {
                if ("==".equals(this.conditionOperator) || "=".equals(this.conditionOperator)) {
                    result = Objects.equals(value, this.conditionThreshold);
                }
                this.logger.fine("Invalid double. " + e.getMessage());
            }
        }
        return result;
    }

    private String httpsQuery() {
        String response = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new LocalX509TrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            LocalHostnameVerifier allHostsValid = new LocalHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URL restUrl = new URL(this.url);
            HttpsURLConnection conn = (HttpsURLConnection)restUrl.openConnection();
            response = this.query(conn);
        }
        catch (Exception e) {
            this.logger.severe("Cannot issue GET on URL " + this.url + ". Monitoring notification is discarded.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return response;
    }

    private String httpQuery() {
        String response = null;
        try {
            URL restUrl = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)restUrl.openConnection();
            response = this.query(conn);
        }
        catch (Exception e) {
            this.logger.severe("Cannot issue GET on URL " + this.url + ". Monitoring notification is discarded.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return response;
    }

    private String query(HttpURLConnection conn) throws IOException {
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", USER_AGENT);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream in = conn.getInputStream();
        Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
        return os.toString("UTF-8");
    }

    static class LocalHostnameVerifier
    implements HostnameVerifier {
        LocalHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return false;
        }
    }

    static class LocalX509TrustManager
    implements X509TrustManager {
        LocalX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

