/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.extensions;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.messages.Message;

public abstract class AbstractRoutingClient<T>
implements IMessagingClient {
    protected final RoutingContext routingContext;
    protected final AtomicBoolean connected = new AtomicBoolean(false);
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected String ownerId;
    protected String applicationName;
    protected String scopedInstancePath;
    protected String domain;
    protected boolean connectionIsRequired = true;

    public AbstractRoutingClient(RoutingContext routingContext, MessagingContext.RecipientKind ownerKind) {
        this.routingContext = routingContext;
        this.setOwnerProperties(ownerKind, null, null, null);
    }

    @Override
    public void closeConnection() throws IOException {
        this.logger.fine(this.getOwnerId() + " is closing its connection.");
        this.connected.set(false);
    }

    @Override
    public void openConnection() throws IOException {
        this.logger.fine(this.getOwnerId() + " is opening a connection.");
        this.connected.set(true);
    }

    @Override
    public Map<String, String> getConfiguration() {
        return Collections.singletonMap("net.roboconf.messaging.type", this.getMessagingType());
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.logger.fine(this.getOwnerId() + " is deleting server artifacts for " + application);
        this.getStaticContextToObject().remove(this.ownerId);
        this.routingContext.subscriptions.remove(this.ownerId);
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void subscribe(MessagingContext ctx) throws IOException {
        this.logger.fine(this.getOwnerId() + " is subscribing to " + AbstractRoutingClient.buildOwnerId(ctx));
        this.subscribe(this.ownerId, ctx);
    }

    @Override
    public void unsubscribe(MessagingContext ctx) throws IOException {
        this.logger.fine(this.getOwnerId() + " is unsubscribing to " + AbstractRoutingClient.buildOwnerId(ctx));
        this.unsubscribe(this.ownerId, ctx);
    }

    @Override
    public void publish(MessagingContext ctx, Message msg) throws IOException {
        this.logger.fine(this.getOwnerId() + " is publishing message (" + msg + ") to " + AbstractRoutingClient.buildOwnerId(ctx));
        if (!this.canProceed()) {
            this.logger.fine(this.getOwnerId() + " is dropping message (" + msg + ") for " + AbstractRoutingClient.buildOwnerId(ctx));
            return;
        }
        for (Map.Entry<String, Set<MessagingContext>> entry : this.routingContext.subscriptions.entrySet()) {
            T obj;
            if (!entry.getValue().contains(ctx) || (obj = this.getStaticContextToObject().get(entry.getKey())) == null) continue;
            this.process(obj, msg);
        }
    }

    @Override
    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
        this.domain = domain;
        String newOwnerId = AbstractRoutingClient.buildOwnerId(ownerKind, applicationName, scopedInstancePath);
        this.logger.fine("New owner ID in " + this.getMessagingType() + " client: " + newOwnerId);
        if (this.ownerId == null) {
            this.ownerId = newOwnerId;
        } else if (!newOwnerId.equals(this.ownerId)) {
            Set<MessagingContext> subscriptions;
            String oldOwnerId = this.ownerId;
            this.ownerId = newOwnerId;
            T obj = this.getStaticContextToObject().remove(oldOwnerId);
            if (obj != null) {
                this.getStaticContextToObject().put(newOwnerId, obj);
            }
            if ((subscriptions = this.routingContext.subscriptions.remove(oldOwnerId)) != null) {
                this.routingContext.subscriptions.put(newOwnerId, subscriptions);
            }
        }
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static String buildOwnerId(MessagingContext.RecipientKind ownerKind, String applicationName, String scopedInstancePath) {
        StringBuilder sb = new StringBuilder();
        if (ownerKind == MessagingContext.RecipientKind.DM) {
            sb.append("@DM@");
        } else {
            if (scopedInstancePath != null) {
                sb.append(scopedInstancePath);
                sb.append(" ");
            }
            if (applicationName != null) {
                sb.append("@ ");
                sb.append(applicationName);
            }
        }
        return sb.toString().trim();
    }

    public static String buildOwnerId(MessagingContext ctx) {
        return ctx == null ? null : AbstractRoutingClient.buildOwnerId(ctx.getKind(), ctx.getApplicationName(), ctx.getComponentOrFacetName());
    }

    protected void subscribe(String id, MessagingContext ctx) throws IOException {
        if (!this.canProceed()) {
            return;
        }
        Set<MessagingContext> sub = this.routingContext.subscriptions.get(id);
        if (sub == null) {
            sub = new HashSet<MessagingContext>();
            this.routingContext.subscriptions.put(id, sub);
        }
        sub.add(ctx);
    }

    protected void unsubscribe(String id, MessagingContext ctx) throws IOException {
        if (!this.canProceed()) {
            return;
        }
        Set<MessagingContext> sub = this.routingContext.subscriptions.get(id);
        if (sub != null) {
            sub.remove(ctx);
            if (sub.isEmpty()) {
                this.routingContext.subscriptions.remove(id);
            }
        }
    }

    protected boolean canProceed() {
        return !this.connectionIsRequired || this.connected.get();
    }

    protected abstract Map<String, T> getStaticContextToObject();

    protected abstract void process(T var1, Message var2) throws IOException;

    public static abstract class RoutingContext {
        public final Map<String, Set<MessagingContext>> subscriptions = new ConcurrentHashMap<String, Set<MessagingContext>>();
    }
}

