/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.internal.client.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.roboconf.core.model.beans.Application;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.messages.Message;

public class TestClient
implements IMessagingClient {
    public AtomicBoolean connected = new AtomicBoolean(false);
    public AtomicBoolean failClosingConnection = new AtomicBoolean(false);
    public AtomicBoolean failSubscribing = new AtomicBoolean(false);
    public AtomicBoolean failMessageSending = new AtomicBoolean(false);
    public Map<MessagingContext, List<Message>> ctxToMessages = new HashMap<MessagingContext, List<Message>>();
    public List<Message> messagesForTheDm = new ArrayList<Message>();
    public List<Message> messagesForAgents = new ArrayList<Message>();
    public List<Message> allSentMessages = new ArrayList<Message>();
    public Set<MessagingContext> subscriptions = new HashSet<MessagingContext>();

    @Override
    public void closeConnection() throws IOException {
        if (this.failClosingConnection.get()) {
            throw new IOException("Closing the connection was configured to fail.");
        }
        this.connected.set(false);
    }

    @Override
    public void openConnection() throws IOException {
        this.connected.set(true);
    }

    @Override
    public String getMessagingType() {
        return "test";
    }

    @Override
    public Map<String, String> getConfiguration() {
        return Collections.singletonMap("net.roboconf.messaging.type", "test");
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
    }

    @Override
    public void subscribe(MessagingContext ctx) throws IOException {
        if (this.failSubscribing.get()) {
            throw new IOException("Subscribing was configured to fail.");
        }
        this.subscriptions.add(ctx);
    }

    @Override
    public void unsubscribe(MessagingContext ctx) throws IOException {
        this.subscriptions.remove(ctx);
    }

    @Override
    public void publish(MessagingContext ctx, Message msg) throws IOException {
        if (this.failMessageSending.get()) {
            throw new IOException("Sending a message was configured to fail.");
        }
        List<Message> messages = this.ctxToMessages.get(ctx);
        if (messages == null) {
            messages = new ArrayList<Message>();
            this.ctxToMessages.put(ctx, messages);
        }
        messages.add(msg);
        this.allSentMessages.add(msg);
        if (ctx.getKind() == MessagingContext.RecipientKind.DM) {
            this.messagesForTheDm.add(msg);
        } else {
            this.messagesForAgents.add(msg);
        }
    }

    @Override
    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
    }

    public void clearMessages() {
        this.ctxToMessages.clear();
        this.messagesForAgents.clear();
        this.messagesForTheDm.clear();
        this.allSentMessages.clear();
    }
}

