/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.reconfigurables;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IClient;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.factory.IMessagingClientFactory;
import net.roboconf.messaging.api.factory.MessagingClientFactoryListener;
import net.roboconf.messaging.api.factory.MessagingClientFactoryRegistry;
import net.roboconf.messaging.api.internal.client.dismiss.DismissClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class ReconfigurableClient<T extends IClient>
implements IClient,
MessagingClientFactoryListener {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final DismissClient dismissClient = new DismissClient();
    private AbstractMessageProcessor<T> messageProcessor;
    private String messagingType;
    private IMessagingClient messagingClient;
    private MessagingClientFactoryRegistry registry;
    protected String domain;

    protected ReconfigurableClient() {
        this.setRegistry(ReconfigurableClient.lookupMessagingClientFactoryRegistryService());
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public synchronized MessagingClientFactoryRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void setRegistry(MessagingClientFactoryRegistry registry) {
        if (this.registry != null) {
            this.registry.removeListener(this);
        }
        this.registry = registry;
        if (registry != null) {
            registry.addListener(this);
        }
    }

    public static MessagingClientFactoryRegistry lookupMessagingClientFactoryRegistryService() {
        MessagingClientFactoryRegistry result = null;
        Bundle bundle = FrameworkUtil.getBundle(ReconfigurableClient.class);
        Logger logger = Logger.getLogger(ReconfigurableClient.class.getName());
        if (bundle != null) {
            logger.info("The messaging registry is used in an OSGi environment.");
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext != null) {
                logger.fine("The bundle context was found.");
                ServiceReference reference = bundleContext.getServiceReference(MessagingClientFactoryRegistry.class);
                if (reference != null) {
                    logger.fine("The service reference was found.");
                    result = (MessagingClientFactoryRegistry)bundleContext.getService(reference);
                }
            }
        } else {
            logger.info("The messaging registry is NOT used in an OSGi environment.");
        }
        return result;
    }

    @Override
    public synchronized String getMessagingType() {
        return this.messagingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchMessagingType(String factoryName) {
        IMessagingClient oldClient;
        this.logger.fine("The messaging is requested to switch its type to " + factoryName + ".");
        IMessagingClient newMessagingClient = null;
        try {
            newMessagingClient = this.createMessagingClient(factoryName);
            if (newMessagingClient != null) {
                newMessagingClient.setMessageQueue(this.messageProcessor.getMessageQueue());
                this.openConnection(newMessagingClient);
            }
        }
        catch (Exception e) {
            this.logger.warning("An error occurred while creating a new messaging client. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n**** WARNING ****\n");
            sb.append("Connection failed at ");
            sb.append(new SimpleDateFormat("HH:mm:ss, 'on' EEEE dd (MMMM)").format(new Date()));
            sb.append(".\n");
            sb.append("The messaging configuration may be invalid.\n");
            sb.append("Or the messaging server may not be started yet.\n\n");
            sb.append("Consider using the 'roboconf:force-reconnect' command if you forgot to start the messaging server.\n");
            sb.append("**** WARNING ****\n");
            System.out.println(sb);
        }
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            oldClient = this.messagingClient;
            this.messagingClient = newMessagingClient;
            this.messagingType = factoryName;
        }
        ReconfigurableClient.closeConnection(oldClient, "The previous client could not be terminated correctly.", this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessagingClientFactory(IMessagingClientFactory factory) {
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            if (this.messagingClient == null && factory.getType().equals(this.messagingType)) {
                IMessagingClient newMessagingClient = null;
                try {
                    newMessagingClient = this.createMessagingClient(factory.getType());
                    if (newMessagingClient != null) {
                        newMessagingClient.setMessageQueue(this.messageProcessor.getMessageQueue());
                        this.openConnection(newMessagingClient);
                    }
                    this.logger.fine("A new messaging factory was added: " + factory.getType());
                }
                catch (IOException e) {
                    this.logger.warning("An error occurred while creating a new messaging client. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
                this.messagingClient = newMessagingClient;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessagingClientFactory(IMessagingClientFactory factory) {
        IMessagingClient oldClient = null;
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            if (this.messagingClient != null && this.messagingClient.getMessagingType().equals(this.messagingType)) {
                oldClient = this.messagingClient;
                this.messagingClient = null;
            }
        }
        ReconfigurableClient.closeConnection(oldClient, "The previous client could not be terminated correctly.", this.logger);
        this.logger.fine("A messaging factory was removed: " + factory != null ? factory.getType() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getConfiguration() {
        Map<String, String> result;
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            result = this.messagingClient != null ? this.messagingClient.getConfiguration() : Collections.emptyMap();
        }
        return result;
    }

    protected IMessagingClient createMessagingClient(String factoryName) throws IOException {
        IMessagingClientFactory factory;
        IMessagingClient client = null;
        MessagingClientFactoryRegistry registry = this.getRegistry();
        if (registry != null && (factory = registry.getMessagingClientFactory(factoryName)) != null) {
            client = factory.createClient(this);
        }
        return client;
    }

    protected abstract void openConnection(IMessagingClient var1) throws IOException;

    protected abstract void configureMessageProcessor(AbstractMessageProcessor<T> var1);

    public abstract MessagingContext.RecipientKind getOwnerKind();

    public void associateMessageProcessor(AbstractMessageProcessor<T> messageProcessor) {
        if (this.messageProcessor != null) {
            throw new IllegalArgumentException("The message processor was already defined.");
        }
        this.messageProcessor = messageProcessor;
        this.configureMessageProcessor(messageProcessor);
        this.messageProcessor.start();
    }

    public AbstractMessageProcessor<T> getMessageProcessor() {
        return this.messageProcessor;
    }

    public synchronized boolean hasValidClient() {
        return this.getMessagingClient().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMessagingClient getMessagingClient() {
        IMessagingClient result;
        ReconfigurableClient reconfigurableClient = this;
        synchronized (reconfigurableClient) {
            result = this.messagingClient != null ? this.messagingClient : this.dismissClient;
        }
        return result;
    }

    protected synchronized IMessagingClient resetInternalClient() {
        IMessagingClient oldClient = this.messagingClient;
        this.messagingClient = null;
        return oldClient;
    }

    static void closeConnection(IMessagingClient client, String errorMessage, Logger logger) {
        if (client != null) {
            try {
                logger.fine("The reconfigurable client is requesting its internal connection to be closed.");
                client.closeConnection();
            }
            catch (Exception e) {
                logger.warning(errorMessage + " " + e.getMessage());
                Utils.logException((Logger)logger, (Throwable)e);
            }
        }
    }
}

