/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.reconfigurables;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IAgentClient;
import net.roboconf.messaging.api.business.ListenerCommand;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdAddImport;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdRemoveImport;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdRequestImport;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifHeartbeat;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.api.utils.MessagingUtils;

public class ReconfigurableClientAgent
extends ReconfigurableClient<IAgentClient>
implements IAgentClient {
    private final ConcurrentHashMap<String, String> externalExports = new ConcurrentHashMap();
    private String applicationName;
    private String scopedInstancePath;
    private String ipAddress;
    private boolean needsModel = false;

    @Override
    protected void openConnection(IMessagingClient newMessagingClient) throws IOException {
        newMessagingClient.setOwnerProperties(this.getOwnerKind(), this.domain, this.applicationName, this.scopedInstancePath);
        newMessagingClient.openConnection();
        this.listenToTheDm(newMessagingClient, ListenerCommand.START);
        MsgNotifHeartbeat msg = new MsgNotifHeartbeat(this.applicationName, this.scopedInstancePath, this.ipAddress);
        msg.setModelRequired(this.needsModel);
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.DM, this.domain, this.applicationName);
        newMessagingClient.publish(ctx, msg);
    }

    @Override
    protected void configureMessageProcessor(AbstractMessageProcessor<IAgentClient> messageProcessor) {
        messageProcessor.setMessagingClient(this);
    }

    @Override
    public MessagingContext.RecipientKind getOwnerKind() {
        return MessagingContext.RecipientKind.AGENTS;
    }

    @Override
    public void setMessageQueue(LinkedBlockingQueue<Message> messageQueue) {
        this.getMessagingClient().setMessageQueue(messageQueue);
    }

    @Override
    public boolean isConnected() {
        return this.getMessagingClient().isConnected();
    }

    @Override
    public void openConnection() throws IOException {
        this.openConnection(this.getMessagingClient());
    }

    @Override
    public void closeConnection() throws IOException {
        IMessagingClient toClose = this.resetInternalClient();
        if (toClose != null) {
            toClose.closeConnection();
        }
    }

    @Override
    public void publishExports(Instance instance) throws IOException {
        Set names = VariableHelpers.findPrefixesForExportedVariables((Instance)instance);
        if (names.isEmpty()) {
            this.logger.fine("Agent '" + this.getAgentId() + "' is publishing its exports.");
        } else {
            for (String facetOrComponentName : names) {
                this.publishExports(instance, facetOrComponentName);
            }
        }
    }

    @Override
    public void publishExports(Instance instance, String facetOrComponentName) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is publishing its exports prefixed by " + facetOrComponentName + ".");
        HashMap<String, String> toPublishInternally = new HashMap<String, String>();
        HashMap<String, String> toPublishExternally = new HashMap<String, String>();
        Map exports = InstanceHelpers.findAllExportedVariables((Instance)instance);
        for (Map.Entry entry : exports.entrySet()) {
            String alias = this.externalExports.get(entry.getKey());
            if (((String)entry.getKey()).startsWith(facetOrComponentName + ".")) {
                toPublishInternally.put((String)entry.getKey(), (String)entry.getValue());
                if (alias == null) continue;
                toPublishExternally.put(alias, (String)entry.getValue());
                continue;
            }
            if (alias == null || !alias.startsWith(facetOrComponentName + ".")) continue;
            toPublishExternally.put(alias, (String)entry.getValue());
        }
        if (!toPublishInternally.isEmpty()) {
            MsgCmdAddImport message = new MsgCmdAddImport(this.applicationName, facetOrComponentName, InstanceHelpers.computeInstancePath((Instance)instance), toPublishInternally);
            MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.AGENTS, this.domain, facetOrComponentName, MessagingContext.ThoseThat.IMPORT, this.applicationName);
            this.getMessagingClient().publish(ctx, message);
        }
        if (!toPublishExternally.isEmpty()) {
            String varName = (String)toPublishExternally.keySet().iterator().next();
            String appTplName = (String)VariableHelpers.parseVariableName((String)varName).getKey();
            MsgCmdAddImport message = new MsgCmdAddImport(this.applicationName, appTplName, InstanceHelpers.computeInstancePath((Instance)instance), toPublishExternally);
            MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.INTER_APP, this.domain, appTplName, MessagingContext.ThoseThat.IMPORT, this.applicationName);
            this.getMessagingClient().publish(ctx, message);
        }
    }

    @Override
    public void unpublishExports(Instance instance) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is un-publishing its exports.");
        for (MessagingContext ctx : MessagingContext.forExportedVariables(this.domain, this.applicationName, instance, this.externalExports, MessagingContext.ThoseThat.IMPORT)) {
            this.logger.fine("Agent '" + this.getAgentId() + "' is un-publishing its exports (" + ctx + ").");
            MsgCmdRemoveImport message = new MsgCmdRemoveImport(this.applicationName, ctx.getComponentOrFacetName(), InstanceHelpers.computeInstancePath((Instance)instance));
            this.getMessagingClient().publish(ctx, message);
        }
    }

    @Override
    public void listenToRequestsFromOtherAgents(ListenerCommand command, Instance instance) throws IOException {
        for (MessagingContext ctx : MessagingContext.forExportedVariables(this.domain, this.applicationName, instance, this.externalExports, MessagingContext.ThoseThat.EXPORT)) {
            if (command == ListenerCommand.START) {
                this.logger.fine("Agent '" + this.getAgentId() + "' starts listening requests from other agents (" + ctx + ").");
                this.getMessagingClient().subscribe(ctx);
                continue;
            }
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening requests from other agents (" + ctx + ").");
            this.getMessagingClient().unsubscribe(ctx);
        }
    }

    @Override
    public void requestExportsFromOtherAgents(Instance instance) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is requesting exports from other agents.");
        for (MessagingContext ctx : MessagingContext.forImportedVariables(this.domain, this.applicationName, instance, MessagingContext.ThoseThat.EXPORT)) {
            this.logger.fine("Agent '" + this.getAgentId() + "' is requesting exports from other agents (" + ctx + ").");
            MsgCmdRequestImport message = new MsgCmdRequestImport(this.applicationName, ctx.getComponentOrFacetName());
            this.getMessagingClient().publish(ctx, message);
        }
    }

    @Override
    public void listenToExportsFromOtherAgents(ListenerCommand command, Instance instance) throws IOException {
        for (MessagingContext ctx : MessagingContext.forImportedVariables(this.domain, this.applicationName, instance, MessagingContext.ThoseThat.IMPORT)) {
            if (command == ListenerCommand.START) {
                this.logger.fine("Agent '" + this.getAgentId() + "' starts listening exports from other agents (" + ctx + ").");
                this.getMessagingClient().subscribe(ctx);
                continue;
            }
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening exports from other agents (" + ctx + ").");
            this.getMessagingClient().unsubscribe(ctx);
        }
    }

    @Override
    public void sendMessageToTheDm(Message message) throws IOException {
        this.logger.fine("Agent '" + this.getAgentId() + "' is sending a " + message.getClass().getSimpleName() + " message to the DM.");
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.DM, this.domain, this.applicationName);
        this.getMessagingClient().publish(ctx, message);
    }

    @Override
    public void listenToTheDm(ListenerCommand command) throws IOException {
        this.listenToTheDm(this.getMessagingClient(), command);
    }

    private void listenToTheDm(IMessagingClient client, ListenerCommand command) throws IOException {
        String topicName = MessagingUtils.buildTopicNameForAgent(this.scopedInstancePath);
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.AGENTS, this.domain, topicName, this.applicationName);
        if (command == ListenerCommand.START) {
            this.logger.fine("Agent '" + this.getAgentId() + "' starts listening to the DM.");
            client.subscribe(ctx);
        } else {
            this.logger.fine("Agent '" + this.getAgentId() + "' stops listening to the DM.");
            client.unsubscribe(ctx);
        }
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        this.getMessagingClient().setOwnerProperties(this.getOwnerKind(), this.domain, applicationName, this.scopedInstancePath);
    }

    @Override
    public void setScopedInstancePath(String scopedInstancePath) {
        this.scopedInstancePath = scopedInstancePath;
        this.getMessagingClient().setOwnerProperties(this.getOwnerKind(), this.domain, this.applicationName, scopedInstancePath);
    }

    @Override
    public void setExternalMapping(Map<String, String> externalExports) {
        this.externalExports.clear();
        if (externalExports != null) {
            this.externalExports.putAll(externalExports);
        }
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setNeedsModel(boolean needsModel) {
        this.needsModel = needsModel;
    }

    private String getAgentId() {
        return Utils.isEmptyOrWhitespaces((String)this.scopedInstancePath) ? "?" : this.scopedInstancePath;
    }
}

