/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.roboconf.messaging.api.messages.Message;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static <T extends Serializable> byte[] serializeObject(T object) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(object);
        return os.toByteArray();
    }

    public static <T extends Serializable> T deserializeObject(byte[] bytes, Class<T> clazz) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectInputStream deserializer = new ObjectInputStream(is);
        return (T)((Serializable)clazz.cast(deserializer.readObject()));
    }

    public static Message deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return SerializationUtils.deserializeObject(bytes, Message.class);
    }
}

