/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.plugin.file.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.UriUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class PluginFile
implements PluginInterface,
Pojo {
    InstanceManager __IM;
    public static final String PLUGIN_NAME = "file";
    static final String FILE_NAME = "instructions.properties";
    static final String TMP_FILE = "roboconf_tmp_file";
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FagentId;
    private String agentId;
    boolean __MgetPluginName;
    boolean __MsetNames$java_lang_String$java_lang_String;
    boolean __Minitialize$net_roboconf_core_model_beans_Instance;
    boolean __Mdeploy$net_roboconf_core_model_beans_Instance;
    boolean __Mstart$net_roboconf_core_model_beans_Instance;
    boolean __Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus;
    boolean __Mstop$net_roboconf_core_model_beans_Instance;
    boolean __Mundeploy$net_roboconf_core_model_beans_Instance;
    boolean __Mexecute$java_lang_String$net_roboconf_core_model_beans_Instance;
    boolean __MreadProperties$net_roboconf_core_model_beans_Instance;
    boolean __MfindActions$java_lang_String$java_util_Properties;
    boolean __MexecuteAction$net_roboconf_plugin_file_internal_PluginFile$Action;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    String __getagentId() {
        if (!this.__FagentId) {
            return this.agentId;
        }
        return (String)this.__IM.onGet((Object)this, "agentId");
    }

    void __setagentId(String string) {
        if (!this.__FagentId) {
            this.agentId = string;
            return;
        }
        this.__IM.onSet((Object)this, "agentId", (Object)string);
    }

    public PluginFile() {
        this(null);
    }

    private PluginFile(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public String getPluginName() {
        String string;
        if (!this.__MgetPluginName) {
            return this.__M_getPluginName();
        }
        try {
            this.__IM.onEntry((Object)this, "getPluginName", new Object[0]);
            string = this.__M_getPluginName();
            this.__IM.onExit((Object)this, "getPluginName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPluginName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPluginName() {
        return PLUGIN_NAME;
    }

    public void setNames(String applicationName, String rootInstanceName) {
        if (!this.__MsetNames$java_lang_String$java_lang_String) {
            this.__M_setNames(applicationName, rootInstanceName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNames$java_lang_String$java_lang_String", new Object[]{applicationName, rootInstanceName});
            this.__M_setNames(applicationName, rootInstanceName);
            this.__IM.onExit((Object)this, "setNames$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNames$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setNames(String applicationName, String rootInstanceName) {
        this.__setagentId("'" + rootInstanceName + "' agent");
    }

    public void initialize(Instance instance) throws PluginException {
        if (!this.__Minitialize$net_roboconf_core_model_beans_Instance) {
            this.__M_initialize(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initialize$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_initialize(instance);
            this.__IM.onExit((Object)this, "initialize$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initialize$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_initialize(Instance instance) throws PluginException {
        this.__getlogger().fine(this.__getagentId() + " has nothing to initialize (file extension).");
    }

    public void deploy(Instance instance) throws PluginException {
        if (!this.__Mdeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_deploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_deploy(instance);
            this.__IM.onExit((Object)this, "deploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_deploy(Instance instance) throws PluginException {
        this.__getlogger().info(this.__getagentId() + " is deploying instance " + instance + ".");
        this.execute("deploy", instance);
    }

    public void start(Instance instance) throws PluginException {
        if (!this.__Mstart$net_roboconf_core_model_beans_Instance) {
            this.__M_start(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_start(instance);
            this.__IM.onExit((Object)this, "start$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_start(Instance instance) throws PluginException {
        this.__getlogger().info(this.__getagentId() + " is starting instance " + instance + ".");
        this.execute("start", instance);
    }

    public void update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        if (!this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus) {
            this.__M_update(instance, importChanged, statusChanged);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", new Object[]{instance, importChanged, statusChanged});
            this.__M_update(instance, importChanged, statusChanged);
            this.__IM.onExit((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus", throwable);
            throw throwable;
        }
    }

    private void __M_update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        this.__getlogger().info(this.__getagentId() + " is updating instance " + instance + ".");
        this.execute("update", instance);
    }

    public void stop(Instance instance) throws PluginException {
        if (!this.__Mstop$net_roboconf_core_model_beans_Instance) {
            this.__M_stop(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_stop(instance);
            this.__IM.onExit((Object)this, "stop$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_stop(Instance instance) throws PluginException {
        this.__getlogger().info(this.__getagentId() + " is stopping instance " + instance + ".");
        this.execute("stop", instance);
    }

    public void undeploy(Instance instance) throws PluginException {
        if (!this.__Mundeploy$net_roboconf_core_model_beans_Instance) {
            this.__M_undeploy(instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            this.__M_undeploy(instance);
            this.__IM.onExit((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_undeploy(Instance instance) throws PluginException {
        this.__getlogger().info(this.__getagentId() + " is undeploying instance " + instance + ".");
        this.execute("undeploy", instance);
    }

    private void execute(String actionName, Instance instance) throws PluginException {
        if (!this.__Mexecute$java_lang_String$net_roboconf_core_model_beans_Instance) {
            this.__M_execute(actionName, instance);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$net_roboconf_core_model_beans_Instance", new Object[]{actionName, instance});
            this.__M_execute(actionName, instance);
            this.__IM.onExit((Object)this, "execute$java_lang_String$net_roboconf_core_model_beans_Instance", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
    }

    private void __M_execute(String actionName, Instance instance) throws PluginException {
        Properties props = this.readProperties(instance);
        for (Action action : this.findActions(actionName, props)) {
            this.executeAction(action);
        }
    }

    Properties readProperties(Instance instance) throws PluginException {
        Properties properties;
        if (!this.__MreadProperties$net_roboconf_core_model_beans_Instance) {
            return this.__M_readProperties(instance);
        }
        try {
            this.__IM.onEntry((Object)this, "readProperties$net_roboconf_core_model_beans_Instance", new Object[]{instance});
            properties = this.__M_readProperties(instance);
            this.__IM.onExit((Object)this, "readProperties$net_roboconf_core_model_beans_Instance", (Object)properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readProperties$net_roboconf_core_model_beans_Instance", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __M_readProperties(Instance instance) throws PluginException {
        Properties result = null;
        File instanceDirectory = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        File file = new File(instanceDirectory, FILE_NAME);
        try {
            if (file.exists()) {
                result = Utils.readPropertiesFile((File)file);
            } else {
                this.__getlogger().warning(file + " does not exist or is invalid. There is no instruction for the plugin.");
                result = new Properties();
            }
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        return result;
    }

    SortedSet<Action> findActions(String actionName, Properties properties) {
        SortedSet<Action> sortedSet;
        if (!this.__MfindActions$java_lang_String$java_util_Properties) {
            return this.__M_findActions(actionName, properties);
        }
        try {
            this.__IM.onEntry((Object)this, "findActions$java_lang_String$java_util_Properties", new Object[]{actionName, properties});
            sortedSet = this.__M_findActions(actionName, properties);
            this.__IM.onExit((Object)this, "findActions$java_lang_String$java_util_Properties", sortedSet);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findActions$java_lang_String$java_util_Properties", throwable);
            throw throwable;
        }
        return sortedSet;
    }

    private SortedSet<Action> __M_findActions(String actionName, Properties properties) {
        Pattern pattern = Pattern.compile(actionName + "\\.(\\d)+\\.(.*)", 2);
        TreeSet<Action> result = new TreeSet<Action>(new ActionComparator());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = String.valueOf(entry.getKey()).toLowerCase();
            Matcher m = pattern.matcher(key);
            if (!m.matches()) continue;
            int position = Integer.parseInt(m.group(1));
            ActionType actionType = ActionType.which(m.group(2));
            String parameter = String.valueOf(entry.getValue());
            result.add(new Action(position, actionType, parameter));
        }
        return result;
    }

    void executeAction(Action action) throws PluginException {
        if (!this.__MexecuteAction$net_roboconf_plugin_file_internal_PluginFile$Action) {
            this.__M_executeAction(action);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "executeAction$net_roboconf_plugin_file_internal_PluginFile$Action", new Object[]{action});
            this.__M_executeAction(action);
            this.__IM.onExit((Object)this, "executeAction$net_roboconf_plugin_file_internal_PluginFile$Action", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "executeAction$net_roboconf_plugin_file_internal_PluginFile$Action", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_executeAction(Action action) throws PluginException {
        try {
            switch (action.actionType) {
                case DELETE: {
                    this.__getlogger().fine("Deleting " + action.parameter + "...");
                    File f = new File(action.parameter);
                    Utils.deleteFilesRecursively((File[])new File[]{f});
                    break;
                }
                case DOWNLOAD: {
                    this.__getlogger().fine("Downloading " + action.parameter + "...");
                    URI uri = UriUtils.urlToUri((String)action.parameter);
                    File targetFile = new File(System.getProperty("java.io.tmpdir"), TMP_FILE);
                    InputStream in = null;
                    try {
                        in = uri.toURL().openStream();
                        Utils.copyStream((InputStream)in, (File)targetFile);
                        break;
                    }
                    finally {
                        Utils.closeQuietly((InputStream)in);
                    }
                }
                case MOVE: {
                    List parts = Utils.splitNicely((String)action.parameter, (String)"->");
                    if (parts.size() != 2) {
                        this.__getlogger().warning("Invalid syntax for 'move' action. " + action.parameter);
                        break;
                    }
                    File source = new File((String)parts.get(0));
                    File target = new File((String)parts.get(1));
                    this.__getlogger().fine("Moving " + source + " to " + target + "...");
                    if (!source.renameTo(target)) {
                        throw new IOException(source + " could not be moved to " + target);
                    }
                    break;
                }
                case COPY: {
                    List parts = Utils.splitNicely((String)action.parameter, (String)"->");
                    if (parts.size() != 2) {
                        this.__getlogger().warning("Invalid syntax for 'copy' action. " + action.parameter);
                        break;
                    }
                    File source = new File((String)parts.get(0));
                    File target = new File((String)parts.get(1));
                    this.__getlogger().fine("Copying " + source + " to " + target + "...");
                    Utils.copyStream((File)source, (File)target);
                    break;
                }
                default: {
                    this.__getlogger().fine("Ignoring the action...");
                }
            }
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("agentId")) {
                this.__FagentId = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPluginName")) {
                this.__MgetPluginName = true;
            }
            if (set.contains("setNames$java_lang_String$java_lang_String")) {
                this.__MsetNames$java_lang_String$java_lang_String = true;
            }
            if (set.contains("initialize$net_roboconf_core_model_beans_Instance")) {
                this.__Minitialize$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("deploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mdeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("start$net_roboconf_core_model_beans_Instance")) {
                this.__Mstart$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("update$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus")) {
                this.__Mupdate$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Import$net_roboconf_core_model_beans_Instance$InstanceStatus = true;
            }
            if (set.contains("stop$net_roboconf_core_model_beans_Instance")) {
                this.__Mstop$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("undeploy$net_roboconf_core_model_beans_Instance")) {
                this.__Mundeploy$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("execute$java_lang_String$net_roboconf_core_model_beans_Instance")) {
                this.__Mexecute$java_lang_String$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("readProperties$net_roboconf_core_model_beans_Instance")) {
                this.__MreadProperties$net_roboconf_core_model_beans_Instance = true;
            }
            if (set.contains("findActions$java_lang_String$java_util_Properties")) {
                this.__MfindActions$java_lang_String$java_util_Properties = true;
            }
            if (set.contains("executeAction$net_roboconf_plugin_file_internal_PluginFile$Action")) {
                this.__MexecuteAction$net_roboconf_plugin_file_internal_PluginFile$Action = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    static enum ActionType {
        NOTHING,
        DOWNLOAD,
        MOVE,
        COPY,
        DELETE;


        public static ActionType which(String s) {
            ActionType result = NOTHING;
            for (ActionType at : ActionType.values()) {
                if (!at.toString().equalsIgnoreCase(s)) continue;
                result = at;
                break;
            }
            return result;
        }
    }

    private static class ActionComparator
    implements Serializable,
    Comparator<Action> {
        private static final long serialVersionUID = 6157709801342723302L;

        private ActionComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            return a1.position - a2.position;
        }
    }

    static class Action {
        int position;
        String parameter;
        ActionType actionType;

        public Action(int position, ActionType actionType, String parameter) {
            this.position = position;
            this.actionType = actionType;
            this.parameter = parameter;
        }

        public boolean equals(Object obj) {
            return obj instanceof Action && this.position == ((Action)obj).position && this.actionType == ((Action)obj).actionType;
        }

        public int hashCode() {
            return this.actionType == null ? 23 : this.actionType.toString().hashCode();
        }
    }
}

