/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.plugin.script.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;

public final class ScriptUtils {
    private ScriptUtils() {
    }

    public static Map<String, String> formatExportedVars(Instance instance) {
        HashMap<String, String> exportedVars = new HashMap<String, String>();
        for (Instance inst = instance; inst != null; inst = inst.getParent()) {
            String prefix = "";
            if (inst != instance) {
                prefix = "ANCESTOR_" + inst.getComponent().getName() + "_";
            }
            Map exports = InstanceHelpers.findAllExportedVariables((Instance)inst);
            for (Map.Entry entry : exports.entrySet()) {
                String vname = prefix + (String)VariableHelpers.parseVariableName((String)((String)entry.getKey())).getValue();
                vname = vname.replaceAll("(-|%s)+", "_");
                exportedVars.put(vname, (String)entry.getValue());
            }
        }
        return exportedVars;
    }

    public static Map<String, String> formatImportedVars(Instance instance) {
        HashMap<String, String> importedVars = new HashMap<String, String>();
        for (Map.Entry entry : instance.getImports().entrySet()) {
            Collection importList = (Collection)entry.getValue();
            String importTypeName = (String)entry.getKey();
            importedVars.put(importTypeName + "_size", "" + importList.size());
            int i = 0;
            for (Import imprt : importList) {
                importedVars.put(importTypeName + "_" + i + "_name", imprt.getInstancePath());
                for (Map.Entry entry2 : imprt.getExportedVars().entrySet()) {
                    String vname = (String)VariableHelpers.parseVariableName((String)((String)entry2.getKey())).getValue();
                    importedVars.put(importTypeName + "_" + i + "_" + vname, (String)entry2.getValue());
                }
                ++i;
            }
        }
        return importedVars;
    }

    public static void setScriptsExecutable(File fileOrDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (fileOrDir.isDirectory()) {
            files.addAll(Utils.listAllFiles((File)fileOrDir, (boolean)true));
        } else {
            files.add(fileOrDir);
        }
        for (File f : files) {
            f.setExecutable(true);
        }
    }

    public static class ActionFileFilter
    implements FilenameFilter {
        final String prefix;

        public ActionFileFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return Utils.isEmptyOrWhitespaces((String)this.prefix) ? false : name.startsWith(this.prefix);
        }
    }
}

