/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.agent.misc;

import java.util.List;
import java.util.logging.Logger;
import net.roboconf.core.runtime.IReconfigurable;
import net.roboconf.core.utils.Utils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="roboconf", name="reload-config", description="Force the DM and/or agents to reload their configuration.")
@Service
public class ReloadConfigurationCommand
implements Action {
    @Reference
    List<IReconfigurable> reconfigurables;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object execute() throws Exception {
        if (this.reconfigurables != null) {
            for (IReconfigurable reconfigurable : this.reconfigurables) {
                try {
                    this.logger.fine("Forcing reconfiguration from a Karaf command.");
                    reconfigurable.reconfigure();
                }
                catch (Exception e) {
                    this.logger.warning("An error occurred while reloading the configuration. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
        return null;
    }
}

