/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl.tracker;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.pax.jdbc.config.impl.tracker.TrackerCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiServiceTracker
implements AutoCloseable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Class<?>, ServiceTracker> trackers = new HashMap();
    private AtomicInteger present;
    private BundleContext context;
    private TrackerCallback callback;
    protected Closeable closeable;
    private Map<Class<?>, Object> services = new HashMap();

    public MultiServiceTracker(BundleContext context, TrackerCallback callback) {
        this.context = context;
        this.callback = callback;
        this.present = new AtomicInteger(0);
    }

    public void track(final Class<?> iface, Filter filter) throws InvalidSyntaxException {
        this.log.info("Tracking service {} with filter {}", (Object)iface.getName(), (Object)filter);
        ServiceTracker tracker = new ServiceTracker(this.context, filter, null){

            public Object addingService(ServiceReference reference) {
                MultiServiceTracker.this.log.info("Found service {} with filter {}", (Object)iface.getName(), (Object)this.filter);
                Object service = super.addingService(reference);
                MultiServiceTracker.this.services.put(iface, service);
                if (MultiServiceTracker.this.present.incrementAndGet() == MultiServiceTracker.this.trackers.size()) {
                    MultiServiceTracker.this.closeable = MultiServiceTracker.this.callback.activate(MultiServiceTracker.this);
                }
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                MultiServiceTracker.this.log.info("Lost service {} with filter {}", (Object)iface.getName(), (Object)this.filter);
                Object oldService = MultiServiceTracker.this.services.get(iface);
                if (service == oldService) {
                    MultiServiceTracker.this.services.remove(iface);
                }
                if (MultiServiceTracker.this.present.decrementAndGet() == MultiServiceTracker.this.trackers.size() - 1) {
                    try {
                        MultiServiceTracker.this.closeable.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                super.removedService(reference, service);
            }
        };
        this.trackers.put(iface, tracker);
    }

    public void open() {
        for (ServiceTracker tracker : this.trackers.values()) {
            tracker.open();
        }
    }

    public <T> T getService(Class<T> iface) {
        return (T)this.services.get(iface);
    }

    @Override
    public void close() {
        for (ServiceTracker tracker : this.trackers.values()) {
            tracker.close();
        }
    }
}

