/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.completers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class LogLevelCompleter
implements Completer {
    static final Level[] LEVELS = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.SEVERE, Level.WARNING};

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter(false);
        for (Level level : LEVELS) {
            delegate.getStrings().add(level.toString());
        }
        return delegate.complete(session, commandLine, candidates);
    }

    public static String all() {
        StringBuilder sb = new StringBuilder();
        Iterator<Level> it = Arrays.asList(LEVELS).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

