/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.completers;

import java.util.List;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class ScopedInstanceCompleter
implements Completer {
    @Reference
    Manager manager;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        ManagedApplication ma;
        String applicationName = null;
        int position = commandLine.getCursorArgumentIndex();
        if (position > 0) {
            applicationName = commandLine.getArguments()[position - 1];
        }
        StringsCompleter delegate = new StringsCompleter(false);
        if (!Utils.isEmptyOrWhitespaces((String)applicationName) && (ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName)) != null) {
            for (Instance inst : InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication())) {
                delegate.getStrings().add(InstanceHelpers.computeInstancePath((Instance)inst));
            }
        }
        return delegate.complete(session, commandLine, candidates);
    }
}

